/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.sqlserver;

import java.util.ArrayList;
import java.util.List;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.sqlserver.Encoder;
import org.geolatte.geom.codec.sqlserver.GeometryCollectionEncoder;
import org.geolatte.geom.codec.sqlserver.LineStringEncoder;
import org.geolatte.geom.codec.sqlserver.OpenGisType;
import org.geolatte.geom.codec.sqlserver.PointEncoder;
import org.geolatte.geom.codec.sqlserver.PolygonEncoder;
import org.geolatte.geom.codec.sqlserver.SqlServerGeometry;

public class Encoders {
    private static final List<Encoder<? extends Geometry>> ENCODERS = new ArrayList<Encoder<? extends Geometry>>();

    public static Encoder<? extends Geometry> encoderFor(Geometry geom) {
        for (Encoder<? extends Geometry> encoder : ENCODERS) {
            if (!encoder.accepts(geom)) continue;
            return encoder;
        }
        throw new IllegalArgumentException("No encoder for type " + (Object)((Object)geom.getGeometryType()));
    }

    public static <T extends Geometry> byte[] encode(T geom) {
        Encoder<? extends Geometry> encoder = Encoders.encoderFor(geom);
        SqlServerGeometry sqlServerGeometry = encoder.encode(geom);
        return SqlServerGeometry.serialize(sqlServerGeometry);
    }

    static {
        ENCODERS.add(new PointEncoder());
        ENCODERS.add(new LineStringEncoder());
        ENCODERS.add(new PolygonEncoder());
        ENCODERS.add(new GeometryCollectionEncoder(OpenGisType.MULTIPOINT));
        ENCODERS.add(new GeometryCollectionEncoder(OpenGisType.MULTILINESTRING));
        ENCODERS.add(new GeometryCollectionEncoder(OpenGisType.MULTIPOLYGON));
        ENCODERS.add(new GeometryCollectionEncoder(OpenGisType.GEOMETRYCOLLECTION));
    }
}

