/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.crs;

import java.util.Arrays;
import org.geolatte.geom.crs.CoordinateSystemAxis;
import org.geolatte.geom.crs.Unit;

public class CoordinateSystem {
    private final CoordinateSystemAxis[] axes;

    public CoordinateSystem(CoordinateSystemAxis ... axes) {
        if (axes == null || axes.length < 2) {
            throw new IllegalArgumentException("Requires at least 2 axes");
        }
        this.axes = axes;
    }

    public CoordinateSystemAxis[] getAxes() {
        return Arrays.copyOf(this.axes, this.axes.length);
    }

    public int getCoordinateDimension() {
        return this.axes.length;
    }

    public int getAxisIndex(CoordinateSystemAxis axis) {
        int i = 0;
        for (CoordinateSystemAxis a : this.axes) {
            if (a == axis) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public CoordinateSystemAxis getAxis(int index) {
        return this.axes[index];
    }

    public Unit getAxisUnit(int index) {
        return this.axes[index].getUnit();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoordinateSystem that = (CoordinateSystem)o;
        return Arrays.equals(this.axes, that.axes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.axes);
    }
}

