/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.curve;

import java.util.regex.Pattern;
import org.geolatte.geom.Envelope;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.Point;
import org.geolatte.geom.crs.CrsId;
import org.geolatte.geom.curve.MortonContext;

public class MortonCode {
    private final Pattern VALID_MORTONCODE_PATTERN = Pattern.compile("[0,1,2,3]*");
    private final MortonContext mortonContext;
    private final double gridWidth;
    private final double gridHeight;
    private final int maxGridCellCoordinate;

    public MortonCode(MortonContext mortonContext) {
        this.mortonContext = mortonContext;
        this.gridWidth = mortonContext.getLeafWidth();
        this.gridHeight = mortonContext.getLeafHeight();
        this.maxGridCellCoordinate = mortonContext.getNumberOfDivisionsAlongAxis() - 1;
    }

    public String ofGeometry(Geometry geometry) {
        this.checkForNull(geometry);
        return this.ofEnvelope(geometry.getEnvelope());
    }

    public String ofEnvelope(Envelope envelope) {
        this.checkForNull(envelope);
        this.checkWithinExtent(envelope);
        int colMin = this.getCol(envelope.getMinX());
        int rowMin = this.getRow(envelope.getMinY());
        int colMax = this.getCol(envelope.getMaxX());
        int rowMax = this.getRow(envelope.getMaxY());
        int[] cols = new int[]{colMin, colMax};
        int[] rows = new int[]{rowMin, rowMax};
        long[] interLeaved = new long[]{0L, 0L};
        for (int i = 0; i < 2; ++i) {
            interLeaved[i] = this.interleave(cols[i], rows[i]);
        }
        return this.commonMortonCodePrefixAsString(interLeaved[0], interLeaved[1]);
    }

    public String ofPoint(Point point) {
        this.checkForNull(point);
        this.checkWithinExtent(point);
        int col = this.getCol(point.getX());
        int row = this.getRow(point.getY());
        long interleaved = this.interleave(col, row);
        return this.pointMortonCodeAsString(interleaved);
    }

    public int getMaxLength() {
        return this.mortonContext.getDepth();
    }

    public Envelope envelopeOf(String mortoncode) {
        if (mortoncode == null || !this.isValidMortonCode(mortoncode)) {
            throw new IllegalArgumentException(String.format("Parameter %s is not a valid mortoncode with max. depth %d.", mortoncode, this.mortonContext.getDepth()));
        }
        return this.envelopeOf(mortoncode, 0, this.mortonContext.getExtent());
    }

    private Envelope envelopeOf(String mortoncode, int index, Envelope extent) {
        assert (extent != null);
        if (index >= mortoncode.length()) {
            return extent;
        }
        char c = mortoncode.charAt(index);
        double minX = extent.getMinX();
        double minY = extent.getMinY();
        double w = extent.getWidth() / 2.0;
        double h = extent.getHeight() / 2.0;
        CrsId crs = extent.getCrsId();
        switch (c) {
            case '0': {
                return this.envelopeOf(mortoncode, ++index, new Envelope(minX, minY, minX + w, minY + h, crs));
            }
            case '1': {
                return this.envelopeOf(mortoncode, ++index, new Envelope(minX, minY + h, minX + w, minY + 2.0 * h, crs));
            }
            case '2': {
                return this.envelopeOf(mortoncode, ++index, new Envelope(minX + w, minY, minX + 2.0 * w, minY + h, crs));
            }
            case '3': {
                return this.envelopeOf(mortoncode, ++index, new Envelope(minX + w, minY + h, minX + 2.0 * w, minY + 2.0 * h, crs));
            }
        }
        throw new IllegalStateException("Received a mortoncode element that is not 0, 1, 2 or 3.");
    }

    private boolean isValidMortonCode(String mortoncode) {
        return mortoncode.length() <= this.mortonContext.getDepth() && this.VALID_MORTONCODE_PATTERN.matcher(mortoncode).matches();
    }

    private int getRow(double y) {
        int col = (int)Math.floor((y - this.mortonContext.getMinY()) / this.gridHeight);
        return col > this.maxGridCellCoordinate ? col - 1 : col;
    }

    private int getCol(double x) {
        int row = (int)Math.floor((x - this.mortonContext.getMinX()) / this.gridWidth);
        return row > this.maxGridCellCoordinate ? row - 1 : row;
    }

    private void checkWithinExtent(Point pnt) {
        if (!this.mortonContext.extentContains(pnt)) {
            throw new IllegalArgumentException("Point not in extent of this MortonCodeContext.");
        }
    }

    private void checkWithinExtent(Envelope envelope) {
        if (!this.mortonContext.extentContains(envelope)) {
            throw new IllegalArgumentException("Geometry envelope not in extent of this MortonCodeContext.");
        }
    }

    private long interleave(int col, int row) {
        long interleaved = 0L;
        for (int i = 0; i < this.mortonContext.getDepth(); ++i) {
            interleaved |= (long)((row & 1 << i) << i | (col & 1 << i) << i + 1);
        }
        return interleaved;
    }

    private String pointMortonCodeAsString(long interleaved) {
        return this.toRadix4String(interleaved, this.mortonContext.getDepth());
    }

    private String commonMortonCodePrefixAsString(long mc1, long mc2) {
        int commonPrefixLength = 0;
        int firstSignificantBit = this.mortonContext.getDepth() * 2;
        long mask = 3 << firstSignificantBit - 2;
        int level = 1;
        while (level <= this.mortonContext.getDepth() && (mc1 & mask ^ mc2 & mask) == 0L) {
            commonPrefixLength = level++;
            mask >>= 2;
        }
        return this.toRadix4String(mc1 >>= firstSignificantBit - commonPrefixLength * 2, commonPrefixLength);
    }

    private String toRadix4String(long interleaved, int level) {
        char[] cbuf = new char[level];
        for (int pos = level - 1; pos >= 0; --pos) {
            int label = (int)interleaved & 3;
            cbuf[pos] = (char)(48 + label);
            interleaved >>= 2;
        }
        return String.valueOf(cbuf);
    }

    private void checkForNull(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Null geometry is not allowed.");
        }
    }
}

