/*
 * Decompiled with CFR 0.152.
 */
package org.everit.persistence.lqmg.internal;

import com.querydsl.sql.SchemaAndTable;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.everit.persistence.lqmg.LQMGException;
import org.everit.persistence.lqmg.internal.ConfigPath;
import org.everit.persistence.lqmg.internal.ConfigValue;
import org.everit.persistence.lqmg.internal.schema.xml.AbstractNamingRuleType;
import org.everit.persistence.lqmg.internal.schema.xml.ClassNameRuleType;
import org.everit.persistence.lqmg.internal.schema.xml.LQMGType;
import org.everit.persistence.lqmg.internal.schema.xml.NamingRulesType;
import org.everit.persistence.lqmg.internal.schema.xml.RegexRuleType;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public class ConfigurationContainer {
    private final Map<SchemaAndTable, ConfigValue<? extends AbstractNamingRuleType>> cache = new HashMap<SchemaAndTable, ConfigValue<? extends AbstractNamingRuleType>>();
    private final Map<SchemaAndTable, ConfigValue<ClassNameRuleType>> classNameRuleMap = new HashMap<SchemaAndTable, ConfigValue<ClassNameRuleType>>();
    private final JAXBContext jaxbContext;
    private final Map<SchemaAndTable, ConfigValue<ClassNameRuleType>> mainClassNameRuleMap = new HashMap<SchemaAndTable, ConfigValue<ClassNameRuleType>>();
    private final Map<SchemaAndTable, ConfigValue<RegexRuleType>> mainRegexRuleMap = new HashMap<SchemaAndTable, ConfigValue<RegexRuleType>>();
    private final Map<String, Pattern> patternsByRegex = new HashMap<String, Pattern>();
    private final Set<ConfigPath> processedConfigs = new HashSet<ConfigPath>();
    private final Map<SchemaAndTable, ConfigValue<RegexRuleType>> regexRuleMap = new HashMap<SchemaAndTable, ConfigValue<RegexRuleType>>();

    public ConfigurationContainer() {
        try {
            this.jaxbContext = JAXBContext.newInstance((String)LQMGType.class.getPackage().getName(), (ClassLoader)this.getClass().getClassLoader());
        }
        catch (JAXBException e) {
            throw new LQMGException("Could not create JAXBContext for configuration", e);
        }
    }

    public void addConfiguration(ConfigPath configPath) {
        URL configurationURL;
        if (!this.processedConfigs.add(configPath)) {
            return;
        }
        Bundle bundle = configPath.bundle;
        String resource = configPath.resource;
        if (bundle == null) {
            try {
                configurationURL = new File(configPath.resource).toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new LQMGException("Could not read configuration from path " + configPath.resource, e);
            }
        } else {
            BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            ClassLoader classLoader = bundleWiring.getClassLoader();
            configurationURL = classLoader.getResource(resource);
        }
        if (configurationURL == null) {
            throw new LQMGException("Configuration file not found on the specified path '" + resource + "' in bundle " + bundle.toString(), null);
        }
        LQMGType lqmgType = this.unmarshalConfiguration(configurationURL);
        this.processLQMGType(lqmgType, resource, bundle);
    }

    private <T extends AbstractNamingRuleType> void addValueToConfigMap(SchemaAndTable schemaAndTable, ConfigValue<T> configValue, Map<SchemaAndTable, ConfigValue<T>> configMap) {
        ConfigValue<T> existingValue;
        ConfigValue<? extends AbstractNamingRuleType> cachedValue = this.cache.get(schemaAndTable);
        if (cachedValue != null) {
            this.cache.remove(schemaAndTable);
        }
        if ((existingValue = configMap.get(schemaAndTable)) != null) {
            StringBuilder sb = new StringBuilder("Configuration is defined more than once: ").append(schemaAndTable.toString()).append("\n");
            Bundle bundle = configValue.bundle;
            if (bundle != null) {
                sb.append("  Bundle: ").append(bundle.toString()).append("; ");
            }
            sb.append("Path: ").append(configValue.configurationXMLPath).append("\n");
            Bundle existingValueBundle = existingValue.bundle;
            if (existingValueBundle != null) {
                sb.append("  Bundle: ").append(existingValueBundle.toString()).append("; ");
            }
            sb.append("Path: ").append(existingValue.configurationXMLPath);
            throw new LQMGException(sb.toString(), null);
        }
        configMap.put(schemaAndTable, configValue);
    }

    public ConfigValue<? extends AbstractNamingRuleType> findConfigForEntity(SchemaAndTable schemaAndTable) {
        ConfigValue<? extends AbstractNamingRuleType> configValue = this.cache.get(schemaAndTable);
        if (configValue != null) {
            if (configValue instanceof NullConfigValue) {
                return null;
            }
            return configValue;
        }
        configValue = this.findEntityConfigInMap(schemaAndTable, this.mainClassNameRuleMap);
        if (configValue != null) {
            return configValue;
        }
        configValue = this.findRegexRuleInMap(schemaAndTable, this.mainRegexRuleMap);
        if (configValue != null) {
            return configValue;
        }
        configValue = this.findEntityConfigInMap(schemaAndTable, this.classNameRuleMap);
        if (configValue != null) {
            return configValue;
        }
        return this.findRegexRuleInMap(schemaAndTable, this.regexRuleMap);
    }

    private ConfigValue<ClassNameRuleType> findEntityConfigInMap(SchemaAndTable schemaAndTable, Map<SchemaAndTable, ConfigValue<ClassNameRuleType>> map) {
        ConfigValue<ClassNameRuleType> configValue = map.get(schemaAndTable);
        if (configValue == null) {
            SchemaAndTable noSchemaAndTable = new SchemaAndTable(null, schemaAndTable.getTable());
            configValue = map.get(noSchemaAndTable);
        }
        return configValue;
    }

    private ConfigValue<RegexRuleType> findRegexRuleInMap(SchemaAndTable schemaAndTable, Map<SchemaAndTable, ConfigValue<RegexRuleType>> map) {
        ArrayList<ConfigValue<RegexRuleType>> result = new ArrayList<ConfigValue<RegexRuleType>>();
        String schemaName = schemaAndTable.getSchema();
        String tableName = schemaAndTable.getTable();
        if (schemaName != null) {
            for (Map.Entry<SchemaAndTable, ConfigValue<RegexRuleType>> entry : map.entrySet()) {
                SchemaAndTable entryKey = entry.getKey();
                ConfigValue<RegexRuleType> configValue = entry.getValue();
                String regex = ((RegexRuleType)configValue.namingRule).getRegex();
                if (!schemaName.equals(entryKey.getSchema()) || !this.matches(regex, tableName)) continue;
                result.add(configValue);
            }
        }
        this.validateConfigValueResultSize(schemaAndTable, result);
        if (result.size() == 1) {
            return (ConfigValue)result.get(0);
        }
        for (Map.Entry<SchemaAndTable, ConfigValue<RegexRuleType>> entry : map.entrySet()) {
            ConfigValue<RegexRuleType> configValue = entry.getValue();
            RegexRuleType regexRule = (RegexRuleType)configValue.namingRule;
            if (regexRule.getSchema() != null || !this.matches(regexRule.getRegex(), tableName)) continue;
            result.add(configValue);
        }
        this.validateConfigValueResultSize(schemaAndTable, result);
        if (result.size() == 1) {
            return (ConfigValue)result.get(0);
        }
        return null;
    }

    public Pattern getPatternByRegex(String regex) {
        Pattern pattern = this.patternsByRegex.get(regex);
        if (pattern == null) {
            pattern = Pattern.compile(regex);
            this.patternsByRegex.put(regex, pattern);
        }
        return pattern;
    }

    private boolean matches(String regex, String value) {
        Pattern pattern = this.getPatternByRegex(regex);
        Matcher matcher = pattern.matcher(value);
        return matcher.matches();
    }

    private void processClassNameRuleType(String xmlConfigurationPath, Bundle bundle, AbstractNamingRuleType lqmgAbstractEntity) {
        ClassNameRuleType lqmgEntity = (ClassNameRuleType)lqmgAbstractEntity;
        SchemaAndTable schemaAndTable = new SchemaAndTable(lqmgEntity.getSchema(), lqmgEntity.getEntity());
        ConfigValue<ClassNameRuleType> configValue = new ConfigValue<ClassNameRuleType>(lqmgEntity, bundle, xmlConfigurationPath);
        this.validatePackage(configValue);
        if (bundle == null) {
            this.addValueToConfigMap(schemaAndTable, configValue, this.mainClassNameRuleMap);
        } else {
            this.addValueToConfigMap(schemaAndTable, configValue, this.classNameRuleMap);
        }
    }

    private void processLQMGType(LQMGType lqmgType, String xmlConfigurationPath, Bundle bundle) {
        String defaultPackageName = lqmgType.getDefaultPackage();
        String defaultSchemaName = lqmgType.getDefaultSchema();
        NamingRulesType entities = lqmgType.getNamingRules();
        if (entities == null) {
            return;
        }
        List<AbstractNamingRuleType> entityAndEntitySet = entities.getClassNameRuleAndRegexRule();
        for (AbstractNamingRuleType lqmgAbstractEntity : entityAndEntitySet) {
            if (lqmgAbstractEntity.getPackage() == null) {
                lqmgAbstractEntity.setPackage(defaultPackageName);
            }
            if (lqmgAbstractEntity.getSchema() == null) {
                lqmgAbstractEntity.setSchema(defaultSchemaName);
            }
            if (lqmgAbstractEntity.getPrefix() == null) {
                lqmgAbstractEntity.setPrefix(lqmgType.getDefaultPrefix());
            }
            if (lqmgAbstractEntity.getSuffix() == null) {
                lqmgAbstractEntity.setSuffix(lqmgType.getDefaultSuffix());
            }
            if (lqmgAbstractEntity instanceof ClassNameRuleType) {
                this.processClassNameRuleType(xmlConfigurationPath, bundle, lqmgAbstractEntity);
                continue;
            }
            if (lqmgAbstractEntity instanceof RegexRuleType) {
                this.processRegexRuleType(xmlConfigurationPath, bundle, lqmgAbstractEntity);
                continue;
            }
            throw new IllegalArgumentException("Unsupported naming rule type [" + lqmgAbstractEntity + "]");
        }
    }

    private void processRegexRuleType(String xmlConfigurationPath, Bundle bundle, AbstractNamingRuleType lqmgAbstractEntity) {
        RegexRuleType lqmgEntitySet = (RegexRuleType)lqmgAbstractEntity;
        SchemaAndTable configKey = new SchemaAndTable(lqmgEntitySet.getSchema(), lqmgEntitySet.getRegex());
        ConfigValue<RegexRuleType> configValue = new ConfigValue<RegexRuleType>(lqmgEntitySet, bundle, xmlConfigurationPath);
        this.validatePackage(configValue);
        if (bundle == null) {
            this.addValueToConfigMap(configKey, configValue, this.mainRegexRuleMap);
        } else {
            this.addValueToConfigMap(configKey, configValue, this.regexRuleMap);
        }
    }

    private void throwMultipleMatchingRegexException(SchemaAndTable schemaAndTable, List<ConfigValue<RegexRuleType>> matchingConfigs) {
        StringBuilder sb = new StringBuilder("Cannot decide which configuration should be applied to '").append(schemaAndTable.getTable()).append("' table of '").append(schemaAndTable.getSchema()).append("' schema. Found matchings:\n");
        for (ConfigValue<RegexRuleType> configValue : matchingConfigs) {
            RegexRuleType namingRule = (RegexRuleType)configValue.namingRule;
            sb.append("  Bundle: ").append(configValue.bundle).append("; XMLPath: ").append(configValue.configurationXMLPath).append("; Schema: ").append(namingRule.getSchema()).append("; Regex: ").append(namingRule.getRegex());
        }
        throw new LQMGException(sb.toString(), null);
    }

    private LQMGType unmarshalConfiguration(URL configurationURL) {
        try {
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            JAXBElement rootElement = (JAXBElement)unmarshaller.unmarshal(configurationURL);
            return (LQMGType)rootElement.getValue();
        }
        catch (JAXBException e) {
            throw new LQMGException("Could not unmarshal LQMG configuration: " + configurationURL.toExternalForm(), e);
        }
    }

    private void validateConfigValueResultSize(SchemaAndTable schemaAndTable, List<ConfigValue<RegexRuleType>> result) {
        if (result.size() > 1) {
            this.throwMultipleMatchingRegexException(schemaAndTable, result);
        }
    }

    private void validatePackage(ConfigValue<? extends AbstractNamingRuleType> configValue) {
        Object namingRule = configValue.namingRule;
        if (((AbstractNamingRuleType)namingRule).getPackage() != null && !"".equals(((AbstractNamingRuleType)namingRule).getPackage().trim())) {
            return;
        }
        StringBuilder sb = new StringBuilder("Missing java package: ConfigValue [bundle=").append(configValue.bundle).append(", configurationXMLPath=").append(configValue.configurationXMLPath).append(", namingRule.schema=").append(((AbstractNamingRuleType)namingRule).getSchema()).append(", ");
        if (namingRule instanceof RegexRuleType) {
            sb.append("namingRule.regex=").append(((RegexRuleType)namingRule).getRegex());
        } else if (namingRule instanceof ClassNameRuleType) {
            sb.append("namingRule.class=").append(((ClassNameRuleType)namingRule).getClazz());
        }
        sb.append("].");
        throw new LQMGException(sb.toString(), null);
    }

    private static class NullConfigValue
    extends ConfigValue<AbstractNamingRuleType> {
        NullConfigValue() {
            super(null, null, null);
        }
    }
}

