/*
 * Decompiled with CFR 0.152.
 */
package org.everit.persistence.lqmg.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.State;
import org.everit.persistence.lqmg.internal.HackUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;

public class EquinoxHackUtilImpl
implements HackUtil {
    private static final int BUFFER_SIZE = 1024;
    private static final Logger LOGGER = Logger.getLogger(EquinoxHackUtilImpl.class.getName());

    private <V> String convertClauseFieldsToString(Map<String, V> map, boolean directives) {
        if (map.size() == 0) {
            return "";
        }
        String assignment = directives ? ":=" : "=";
        Set<Map.Entry<String, V>> set = map.entrySet();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, V> entry : set) {
            sb.append(";");
            String key = entry.getKey();
            V value = entry.getValue();
            if (value instanceof List) {
                List list = (List)value;
                if (list.size() == 0) continue;
                sb.append(key).append(assignment).append('\"');
                for (Object object : list) {
                    sb.append(this.escapeClauseValue(object)).append(',');
                }
                sb.setLength(sb.length() - 1);
                sb.append('\"');
                continue;
            }
            sb.append(key).append(assignment).append('\"').append(this.escapeClauseValue(value)).append('\"');
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyBundleEntryIntoJar(Bundle bundle, String entry, JarOutputStream jarOut) throws IOException {
        jarOut.putNextEntry(new ZipEntry(entry));
        URL resource = bundle.getResource(entry);
        try (InputStream in = resource.openStream();){
            byte[] buf = new byte[1024];
            int r = in.read(buf);
            while (r > -1) {
                jarOut.write(buf, 0, r);
                r = in.read(buf);
            }
        }
    }

    private String createClauseString(String namespace, Map<String, Object> attributeMap, Map<String, String> directiveMap) {
        String attributesPart = this.convertClauseFieldsToString(attributeMap, false);
        String directivesPart = this.convertClauseFieldsToString(directiveMap, true);
        StringBuilder sb = new StringBuilder(namespace);
        if (!"".equals(attributesPart)) {
            sb.append(attributesPart);
        }
        if (!"".equals(directivesPart)) {
            sb.append(directivesPart);
        }
        return sb.toString();
    }

    private Manifest createHackedManifest(Bundle bundle, BundleDescription bundleDescription, List<BundleCapability> availableCapabilities) {
        List declaredRequirements = bundleDescription.getDeclaredRequirements(null);
        Manifest manifest = this.readOriginalManifest(bundle);
        Attributes mainAttributes = manifest.getMainAttributes();
        this.hackImportPackageManifestHeader(bundleDescription, availableCapabilities, mainAttributes);
        this.hackRequireBundleManifestHeader(bundleDescription, availableCapabilities, mainAttributes);
        StringBuilder sb = new StringBuilder();
        for (BundleRequirement declaredRequirement : declaredRequirements) {
            String namespace = declaredRequirement.getNamespace();
            if (namespace.equals("osgi.wiring.package") || namespace.equals("osgi.wiring.host") || namespace.equals("osgi.wiring.bundle")) continue;
            HashMap<String, String> directives = declaredRequirement.getDirectives();
            Map attributes = declaredRequirement.getAttributes();
            boolean optional = "optional".equals(declaredRequirement.getDirectives().get("resolution"));
            if (!optional && !this.requirementSatisfiable(declaredRequirement, availableCapabilities)) {
                LOGGER.info("[HACK]: Making Require-Capability optional in bundle " + bundleDescription.toString() + ": " + declaredRequirement.toString());
                directives = new HashMap<String, String>(directives);
                directives.put("resolution", "optional");
            }
            String clauseString = this.createClauseString(namespace, attributes, (Map<String, String>)directives);
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(clauseString);
        }
        if (sb.length() > 0) {
            mainAttributes.putValue("Require-Capability", sb.toString());
        }
        return manifest;
    }

    private String escapeClauseValue(Object object) {
        String stringValue = String.valueOf(object);
        return stringValue.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    private List<BundleCapability> getAllCapabilities(Bundle[] bundles, State state) {
        ArrayList<BundleCapability> availableCapabilities = new ArrayList<BundleCapability>();
        for (Bundle bundle : bundles) {
            BundleDescription bundleDescription = state.getBundle(bundle.getBundleId());
            List declaredCapabilities = bundleDescription.getDeclaredCapabilities(null);
            availableCapabilities.addAll(declaredCapabilities);
        }
        return availableCapabilities;
    }

    private void hackBundle(Bundle bundle, BundleDescription bundleDescription, List<BundleCapability> availableCapabilities) {
        Manifest manifest = this.createHackedManifest(bundle, bundleDescription, availableCapabilities);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            JarOutputStream jarOut = new JarOutputStream((OutputStream)bout, manifest);
            AbstractBundle abstractBundle = (AbstractBundle)bundle;
            BaseData bundleData = (BaseData)abstractBundle.getBundleData();
            BundleFile bundleFile = bundleData.getBundleFile();
            BaseAdaptor adaptor = (BaseAdaptor)abstractBundle.getFramework().getAdaptor();
            List entries = adaptor.listEntryPaths(Arrays.asList(bundleFile), "/", null, 1);
            for (String entry : entries) {
                if ("META-INF/MANIFEST.MF".equals(entry) || entry.endsWith("/")) continue;
                this.copyBundleEntryIntoJar(bundle, entry, jarOut);
            }
            jarOut.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            bundle.update((InputStream)new ByteArrayInputStream(bout.toByteArray()));
        }
        catch (BundleException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void hackBundles(Framework osgiContainer, File tempDirectory) {
        BundleContext systemBundleContext = osgiContainer.getBundleContext();
        ServiceReference platformServiceSR = systemBundleContext.getServiceReference(PlatformAdmin.class);
        PlatformAdmin platformAdmin = (PlatformAdmin)systemBundleContext.getService(platformServiceSR);
        State state = platformAdmin.getState();
        Bundle[] bundles = systemBundleContext.getBundles();
        List<BundleCapability> availableCapabilities = this.getAllCapabilities(bundles, state);
        for (Bundle bundle : bundles) {
            if (bundle.getState() != 2) continue;
            BundleDescription bundleDescription = state.getBundle(bundle.getBundleId());
            this.hackBundle(bundle, bundleDescription, availableCapabilities);
        }
    }

    private void hackImportPackageManifestHeader(BundleDescription bundleDescription, List<BundleCapability> availableCapabilities, Attributes mainAttributes) {
        ImportPackageSpecification[] allImports;
        StringBuilder hackedImportPackageSB = new StringBuilder();
        for (ImportPackageSpecification importPackage : allImports = bundleDescription.getImportPackages()) {
            if (hackedImportPackageSB.length() > 0) {
                hackedImportPackageSB.append(",");
            }
            hackedImportPackageSB.append(importPackage.getName()).append(";version=\"").append(importPackage.getVersionRange()).append("\"");
            boolean optional = "optional".equals(importPackage.getDirective("resolution"));
            if (!optional && this.requirementSatisfiable(importPackage.getRequirement(), availableCapabilities)) continue;
            if (!optional) {
                LOGGER.info("[HACK]: Making Import-Package optional in bundle " + bundleDescription.toString() + ": " + hackedImportPackageSB.toString());
            }
            hackedImportPackageSB.append(";").append("resolution").append(":=").append("\"").append("optional").append("\"");
        }
        if (hackedImportPackageSB.length() > 0) {
            mainAttributes.putValue("Import-Package", hackedImportPackageSB.toString());
        }
    }

    private void hackRequireBundleManifestHeader(BundleDescription bundleDescription, List<BundleCapability> availableCapabilities, Attributes mainAttributes) {
        BundleSpecification[] requiredBundles;
        StringBuilder hackedRequireBundleSB = new StringBuilder();
        for (BundleSpecification requiredBundle : requiredBundles = bundleDescription.getRequiredBundles()) {
            if (hackedRequireBundleSB.length() > 0) {
                hackedRequireBundleSB.append(",");
            }
            hackedRequireBundleSB.append(requiredBundle.getName() + ";bundle-version=\"" + requiredBundle.getVersionRange() + "\"");
            if (!requiredBundle.isOptional() && this.requirementSatisfiable(requiredBundle.getRequirement(), availableCapabilities)) continue;
            if (!requiredBundle.isOptional()) {
                LOGGER.info("[HACK]: Making Require-Bundle optional in bundle " + bundleDescription.toString() + ": " + hackedRequireBundleSB.toString());
            }
            hackedRequireBundleSB.append(";").append("resolution").append(":=").append("\"").append("optional").append("\"");
        }
        if (hackedRequireBundleSB.length() > 0) {
            mainAttributes.putValue("Require-Bundle", hackedRequireBundleSB.toString());
        }
    }

    private Manifest readOriginalManifest(Bundle bundle) {
        URL manifestURL = bundle.getResource("/META-INF/MANIFEST.MF");
        InputStream manifestStream = null;
        try {
            manifestStream = manifestURL.openStream();
            Manifest manifest = new Manifest(manifestStream);
            return manifest;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (manifestStream != null) {
                try {
                    manifestStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private boolean requirementSatisfiable(BundleRequirement requirement, List<BundleCapability> availableCapabilities) {
        for (BundleCapability bundleCapability : availableCapabilities) {
            try {
                if (!requirement.matches(bundleCapability)) continue;
                return true;
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.WARNING, "Capability does not match the requirement.", e);
            }
        }
        return false;
    }
}

