/*
 * Decompiled with CFR 0.152.
 */
package org.everit.persistence.lqmg.internal;

import com.querydsl.codegen.EntityType;
import com.querydsl.sql.SchemaAndTable;
import com.querydsl.sql.codegen.DefaultNamingStrategy;
import com.querydsl.sql.codegen.support.ForeignKeyData;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBElement;
import org.everit.persistence.lqmg.LQMGException;
import org.everit.persistence.lqmg.internal.ConfigValue;
import org.everit.persistence.lqmg.internal.ConfigurationContainer;
import org.everit.persistence.lqmg.internal.schema.xml.AbstractNamingRuleType;
import org.everit.persistence.lqmg.internal.schema.xml.ClassNameRuleType;
import org.everit.persistence.lqmg.internal.schema.xml.PropertyMappingType;
import org.everit.persistence.lqmg.internal.schema.xml.PropertyMappingsType;
import org.everit.persistence.lqmg.internal.schema.xml.RegexRuleType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LQMGNamingStrategy
extends DefaultNamingStrategy {
    private static final String FK_PREFIX = "fk_";
    private static final Logger LOGGER = LoggerFactory.getLogger(LQMGNamingStrategy.class);
    private static final String PK_PREFIX = "pk_";
    private final Map<SchemaAndTable, String> classNameCache = new HashMap<SchemaAndTable, String>();
    private final ConfigurationContainer configurationContainer;
    private final Set<String> packages;

    public LQMGNamingStrategy(ConfigurationContainer configurationContainer, String[] packages) {
        this.configurationContainer = configurationContainer;
        this.packages = new HashSet<String>(Arrays.asList(packages));
    }

    @Override
    public String getClassName(SchemaAndTable schemaAndTable) {
        String suffix;
        String simpleName = this.classNameCache.get(schemaAndTable);
        if (simpleName != null) {
            return simpleName;
        }
        ConfigValue<? extends AbstractNamingRuleType> configValue = this.configurationContainer.findConfigForEntity(schemaAndTable);
        if (configValue == null) {
            return null;
        }
        Object namingRule = configValue.namingRule;
        if (namingRule instanceof RegexRuleType) {
            RegexRuleType regexRule = (RegexRuleType)namingRule;
            String regex = regexRule.getRegex();
            String replacement = regexRule.getReplacement();
            Pattern pattern = this.configurationContainer.getPatternByRegex(regex);
            Matcher matcher = pattern.matcher(schemaAndTable.getTable());
            String replacedEntityName = matcher.replaceAll(replacement);
            simpleName = super.getClassName(replacedEntityName);
        } else if (namingRule instanceof ClassNameRuleType) {
            simpleName = ((ClassNameRuleType)namingRule).getClazz();
        }
        String prefix = ((AbstractNamingRuleType)namingRule).getPrefix();
        if (prefix != null) {
            simpleName = prefix + simpleName;
        }
        if ((suffix = ((AbstractNamingRuleType)namingRule).getSuffix()) != null) {
            simpleName = simpleName + suffix;
        }
        this.classNameCache.put(schemaAndTable, simpleName);
        if (simpleName == null) {
            throw new LQMGException("Cannot resolve class name for '" + schemaAndTable.getTable() + "' table in '" + schemaAndTable.getSchema() + "' schema.", null);
        }
        return simpleName;
    }

    @Override
    public String getDefaultVariableName(EntityType entityType) {
        SchemaAndTable schemaAndTable = this.getSchemaAndTable(entityType);
        String propertyName = this.getClassName(schemaAndTable);
        ConfigValue<? extends AbstractNamingRuleType> config = this.configurationContainer.findConfigForEntity(schemaAndTable);
        AbstractNamingRuleType namingRule = config.getNamingRule();
        String prefix = namingRule.getPrefix();
        String suffix = namingRule.getSuffix();
        if (prefix != null) {
            propertyName = propertyName.substring(prefix.length());
        }
        if (suffix != null) {
            propertyName = propertyName.substring(0, propertyName.length() - suffix.length());
        }
        propertyName = Character.toLowerCase(propertyName.charAt(0)) + propertyName.substring(1);
        return this.escape(entityType, propertyName);
    }

    private List<JAXBElement<PropertyMappingType>> getForeignKeyAndPrimaryKeyAndColumnForEntity(EntityType entityType) {
        SchemaAndTable schemaAndTable = this.getSchemaAndTable(entityType);
        ConfigValue<? extends AbstractNamingRuleType> configValue = this.configurationContainer.findConfigForEntity(schemaAndTable);
        if (configValue == null) {
            return null;
        }
        AbstractNamingRuleType namingRule = configValue.getNamingRule();
        if (!(namingRule instanceof ClassNameRuleType)) {
            return null;
        }
        PropertyMappingsType propertyMappings = ((ClassNameRuleType)namingRule).getPropertyMappings();
        if (propertyMappings == null) {
            return null;
        }
        return propertyMappings.getPrimaryKeyAndForeignKeyAndColumn();
    }

    @Override
    public String getPackage(String basePackage, SchemaAndTable schemaAndTable) {
        String simpleName = this.getClassName(schemaAndTable);
        if (simpleName == null) {
            throw new LQMGException("Cannot resolve class name for '" + schemaAndTable.getTable() + "' table in '" + schemaAndTable.getSchema() + "' schema.", null);
        }
        ConfigValue<? extends AbstractNamingRuleType> configValue = this.configurationContainer.findConfigForEntity(schemaAndTable);
        AbstractNamingRuleType namingRule = configValue.getNamingRule();
        String packageName = namingRule.getPackage();
        return packageName;
    }

    @Override
    public String getPropertyName(String columnName, EntityType entityType) {
        String propertyName = this.getPropertyNameFromMapping(columnName, entityType, DBAttributeType.COLUMN);
        if (propertyName != null) {
            return propertyName;
        }
        return super.getPropertyName(columnName, entityType);
    }

    @Override
    public String getPropertyNameForForeignKey(String fkName, EntityType entityType) {
        String localFkName = fkName;
        String propertyName = this.getPropertyNameFromMapping(localFkName, entityType, DBAttributeType.FOREIGN_KEY);
        if (propertyName != null) {
            return propertyName;
        }
        if (localFkName.toLowerCase(Locale.ENGLISH).startsWith(FK_PREFIX)) {
            localFkName = localFkName.substring(FK_PREFIX.length()) + "_" + localFkName.substring(0, 2);
        }
        return this.getSuperPropertyName(localFkName, entityType);
    }

    @Override
    public String getPropertyNameForPrimaryKey(String pkName, EntityType entityType) {
        String localPkName = pkName;
        String propertyName = this.getPropertyNameFromMapping(localPkName, entityType, DBAttributeType.PRIMARY_KEY);
        if (propertyName != null) {
            return propertyName;
        }
        if (localPkName.toLowerCase(Locale.ENGLISH).startsWith(PK_PREFIX)) {
            localPkName = localPkName.substring(PK_PREFIX.length()) + "_" + localPkName.substring(0, 2);
        }
        return this.getSuperPropertyName(localPkName, entityType);
    }

    private String getPropertyNameFromMapping(String originalName, EntityType entityType, DBAttributeType dbAttributeType) {
        List<JAXBElement<PropertyMappingType>> foreignKeyAndPrimaryKeyAndColumn = this.getForeignKeyAndPrimaryKeyAndColumnForEntity(entityType);
        if (foreignKeyAndPrimaryKeyAndColumn == null) {
            return null;
        }
        PropertyMappingType selectedMapping = null;
        Iterator<JAXBElement<PropertyMappingType>> iterator = foreignKeyAndPrimaryKeyAndColumn.iterator();
        while (iterator.hasNext() && selectedMapping == null) {
            PropertyMappingType propertyMapping;
            JAXBElement<PropertyMappingType> jaxbElement = iterator.next();
            if (!dbAttributeType.getTypeName().equals(jaxbElement.getName().getLocalPart()) || !(propertyMapping = (PropertyMappingType)jaxbElement.getValue()).getName().equals(originalName)) continue;
            selectedMapping = propertyMapping;
        }
        if (selectedMapping != null) {
            return selectedMapping.getProperty();
        }
        return null;
    }

    private SchemaAndTable getSchemaAndTable(EntityType entityType) {
        String tableName = entityType.getData().get("table").toString();
        String schemaName = (String)entityType.getData().get("schema");
        SchemaAndTable schemaAndTable = new SchemaAndTable(schemaName, tableName);
        return schemaAndTable;
    }

    private String getSuperPropertyName(String columnName, EntityType entityType) {
        return super.getPropertyName(columnName, entityType);
    }

    private boolean shouldGenerate(SchemaAndTable schemaAndTable) {
        ConfigValue<? extends AbstractNamingRuleType> configValue = this.configurationContainer.findConfigForEntity(schemaAndTable);
        if (configValue == null) {
            LOGGER.info("No configuration for table '" + schemaAndTable.getTable() + "' in schema '" + schemaAndTable.getSchema());
            return false;
        }
        AbstractNamingRuleType namingRule = configValue.getNamingRule();
        String javaPackage = namingRule.getPackage();
        if (this.packages.size() > 0 && !this.packages.contains(javaPackage)) {
            LOGGER.info("Java package '" + javaPackage + "' is not included, ignoring table '" + schemaAndTable.getTable() + "' from schema '." + schemaAndTable.getSchema());
            return false;
        }
        return true;
    }

    @Override
    public boolean shouldGenerateClass(SchemaAndTable schemaAndTable) {
        if (this.shouldGenerate(schemaAndTable)) {
            return super.shouldGenerateClass(schemaAndTable);
        }
        return false;
    }

    @Override
    public boolean shouldGenerateForeignKey(SchemaAndTable schemaAndTable, ForeignKeyData foreignKeyData) {
        String fkTableName;
        String fkSchemaName = foreignKeyData.getSchema();
        SchemaAndTable fkSchemaAndTable = new SchemaAndTable(fkSchemaName, fkTableName = foreignKeyData.getTable());
        if (this.shouldGenerate(fkSchemaAndTable)) {
            return super.shouldGenerateForeignKey(schemaAndTable, foreignKeyData);
        }
        return false;
    }

    private static enum DBAttributeType {
        COLUMN("column"),
        FOREIGN_KEY("foreignKey"),
        PRIMARY_KEY("primaryKey");

        private String typeName;

        private DBAttributeType(String typeName) {
            this.typeName = typeName;
        }

        public String getTypeName() {
            return this.typeName;
        }
    }
}

