/*
 * Decompiled with CFR 0.152.
 */
package org.everit.persistence.lqmg.internal.liquibase;

import java.util.Map;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.database.Database;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.osgi.OSGiResourceAccessor;
import liquibase.precondition.core.PreconditionContainer;
import liquibase.resource.ResourceAccessor;
import org.everit.persistence.liquibase.ext.osgi.EOSGiResourceAccessor;
import org.everit.persistence.lqmg.LQMGException;
import org.everit.persistence.lqmg.internal.ConfigPath;
import org.everit.persistence.lqmg.internal.ConfigurationContainer;
import org.osgi.framework.Bundle;

public class LQMGChangeExecListener
implements ChangeExecListener {
    private final ConfigurationContainer configurationContainer;

    public LQMGChangeExecListener(ConfigurationContainer configurationContainer) {
        this.configurationContainer = configurationContainer;
    }

    public void preconditionErrored(PreconditionErrorException error, PreconditionContainer.ErrorOption onError) {
    }

    public void preconditionFailed(PreconditionFailedException error, PreconditionContainer.FailOption onFail) {
    }

    public void ran(Change change, ChangeSet changeSet, DatabaseChangeLog changeLog, Database database) {
        if (!(change instanceof AbstractChange)) {
            throw new LQMGException("Change must be a descendant of AbstractChange: " + change.getClass().getName(), null);
        }
        AbstractChange abstractChange = (AbstractChange)change;
        ResourceAccessor resourceAccessor = abstractChange.getResourceAccessor();
        if (!(resourceAccessor instanceof OSGiResourceAccessor)) {
            throw new LQMGException("Resource accessor must have type OSGiResourceAccessor: " + resourceAccessor.getClass().getName(), null);
        }
        EOSGiResourceAccessor osgiResourceAccessor = (EOSGiResourceAccessor)resourceAccessor;
        Bundle bundle = osgiResourceAccessor.getBundle();
        Map attributes = osgiResourceAccessor.getAttributes();
        String configPath = (String)attributes.get("lqmg.config.resource");
        if (configPath != null) {
            this.configurationContainer.addConfiguration(new ConfigPath(bundle, configPath));
        }
    }

    public void ran(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, ChangeSet.ExecType execType) {
    }

    public void rolledBack(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database) {
    }

    public void runFailed(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, Exception exception) {
    }

    public void willRun(Change change, ChangeSet changeSet, DatabaseChangeLog changeLog, Database database) {
    }

    public void willRun(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, ChangeSet.RunStatus runStatus) {
    }
}

