/*
 * Decompiled with CFR 0.152.
 */
package org.everit.persistence.liquibase.ext.osgi.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.felix.utils.manifest.Attribute;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Directive;
import org.apache.felix.utils.manifest.Parser;
import org.everit.persistence.liquibase.ext.osgi.util.BundleResource;
import org.everit.persistence.liquibase.ext.osgi.util.SchemaExpressionSyntaxException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public final class LiquibaseOSGiUtil {
    public static Filter createFilterForLiquibaseCapabilityAttributes(String schemaExpression) {
        Clause[] clauses = Parser.parseClauses((String[])new String[]{schemaExpression});
        if (clauses.length != 1) {
            throw new SchemaExpressionSyntaxException("The number of Clauses in the Schema expression should be 1");
        }
        Clause clause = clauses[0];
        String schemaName = clause.getName();
        Attribute[] attributes = clause.getAttributes();
        if (attributes.length > 0) {
            throw new SchemaExpressionSyntaxException("No Attributes in the schema expresson are supported.");
        }
        Directive[] directives = clause.getDirectives();
        String filterString = "(liquibase.changelog=" + schemaName + ")";
        if (directives.length == 1) {
            if (!"filter".equals(directives[0].getName())) {
                throw new SchemaExpressionSyntaxException("Only the 'filter' directive is supported in the schema expression");
            }
            String additionalFilterString = directives[0].getValue();
            filterString = "(&" + filterString + additionalFilterString + ")";
        }
        try {
            return FrameworkUtil.createFilter((String)filterString);
        }
        catch (InvalidSyntaxException e) {
            throw new SchemaExpressionSyntaxException("The filter contains an invalid filter string");
        }
    }

    public static List<BundleResource> findBundlesBySchemaExpression(String schemaExpression, BundleContext bundleContext, int necessaryBundleStates) {
        Bundle[] bundles;
        Filter filter = LiquibaseOSGiUtil.createFilterForLiquibaseCapabilityAttributes(schemaExpression);
        ArrayList<BundleResource> result = new ArrayList<BundleResource>();
        for (Bundle bundle : bundles = bundleContext.getBundles()) {
            int state = bundle.getState();
            if ((state & necessaryBundleStates) == 0) continue;
            BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            List capabilities = bundleWiring.getCapabilities("liquibase.changelog");
            for (BundleCapability capability : capabilities) {
                Map attributes = capability.getAttributes();
                Object schemaResourceAttr = attributes.get("resource");
                if (schemaResourceAttr == null || !filter.matches(attributes)) continue;
                result.add(new BundleResource(bundle, String.valueOf(schemaResourceAttr), attributes));
            }
        }
        return result;
    }

    public static BundleResource findMatchingWireBySchemaExpression(Bundle currentBundle, String schemaExpression) {
        BundleWiring bundleWiring = (BundleWiring)currentBundle.adapt(BundleWiring.class);
        List wires = bundleWiring.getRequiredWires("liquibase.changelog");
        if (wires.size() == 0) {
            return null;
        }
        Filter capabilityFilter = LiquibaseOSGiUtil.createFilterForLiquibaseCapabilityAttributes(schemaExpression);
        Iterator iterator = wires.iterator();
        BundleResource bundleResource = null;
        while (bundleResource == null && iterator.hasNext()) {
            Object schemaResourceAttr;
            BundleWire wire = (BundleWire)iterator.next();
            BundleCapability capability = wire.getCapability();
            Map capabilityAttributes = capability.getAttributes();
            if (!capabilityFilter.matches(capabilityAttributes) || (schemaResourceAttr = capabilityAttributes.get("resource")) == null) continue;
            bundleResource = new BundleResource(capability.getRevision().getBundle(), String.valueOf(schemaResourceAttr), capabilityAttributes);
        }
        return bundleResource;
    }

    private LiquibaseOSGiUtil() {
    }
}

