/*
 * Decompiled with CFR 0.152.
 */
package org.everit.persistence.lqmg;

import com.querydsl.sql.codegen.MetaDataExporter;
import com.querydsl.sql.codegen.NamingStrategy;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import liquibase.Liquibase;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.database.core.H2Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ResourceAccessor;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.everit.persistence.liquibase.ext.osgi.EOSGiResourceAccessor;
import org.everit.persistence.liquibase.ext.osgi.util.BundleResource;
import org.everit.persistence.liquibase.ext.osgi.util.LiquibaseOSGiUtil;
import org.everit.persistence.lqmg.GenerationProperties;
import org.everit.persistence.lqmg.LQMGException;
import org.everit.persistence.lqmg.internal.ConfigPath;
import org.everit.persistence.lqmg.internal.ConfigurationContainer;
import org.everit.persistence.lqmg.internal.EquinoxHackUtilImpl;
import org.everit.persistence.lqmg.internal.HackUtil;
import org.everit.persistence.lqmg.internal.LQMGNamingStrategy;
import org.everit.persistence.lqmg.internal.liquibase.LQMGChangeExecListener;
import org.h2.Driver;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;
import org.osgi.framework.wiring.FrameworkWiring;

public final class LQMG {
    public static final String CAPABILITY_LQMG_CONFIG_RESOURCE = "lqmg.config.resource";
    private static HackUtil frameworkUtil = new EquinoxHackUtilImpl();
    private static final Logger LOGGER = Logger.getLogger(LQMG.class.getName());

    private static void checkMatchingBundleResourceSize(GenerationProperties parameters, List<BundleResource> bundleResources) {
        if (bundleResources.size() > 1) {
            LOGGER.log(Level.WARNING, "Found multiple bundles containing matching capabilities for schema expression: '" + parameters.capability + "'. Using the first one from list: " + bundleResources.toString());
        }
    }

    private static String createDataBaseURL(String defaultSchema) {
        StringBuilder sb = new StringBuilder("jdbc:h2:mem:");
        if (defaultSchema != null) {
            sb.append(";INIT=CREATE SCHEMA IF NOT EXISTS \"").append(defaultSchema).append("\"\\;SET SCHEMA \"").append(defaultSchema).append("\"");
        }
        return sb.toString();
    }

    private static File createTempDirectory() throws IOException {
        File temp = File.createTempFile("lqmg-", Long.toString(System.nanoTime()));
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        return temp;
    }

    private static void deleteFolder(File folder) {
        if (folder == null) {
            return;
        }
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    LQMG.deleteFolder(f);
                    continue;
                }
                if (f.delete()) continue;
                LOGGER.warning("Failed to delete file [" + f.getAbsolutePath() + "]");
            }
        }
        if (!folder.delete()) {
            LOGGER.warning("Failed to delete folder [" + folder.getAbsolutePath() + "]");
        }
    }

    private static void exportMetaData(GenerationProperties parameters, Connection connection, ConfigurationContainer configurationContainer) throws SQLException {
        LOGGER.log(Level.INFO, "Start meta data export.");
        MetaDataExporter metaDataExporter = new MetaDataExporter();
        LQMGNamingStrategy namingStrategy = new LQMGNamingStrategy(configurationContainer, parameters.packages);
        metaDataExporter.setNamePrefix("");
        metaDataExporter.setNameSuffix("");
        metaDataExporter.setNamingStrategy((NamingStrategy)namingStrategy);
        metaDataExporter.setSchemaToPackage(true);
        metaDataExporter.setTargetFolder(new File(parameters.targetFolder));
        metaDataExporter.setInnerClassesForKeys(parameters.innerClassesForKeys);
        metaDataExporter.export(connection.getMetaData());
        LOGGER.log(Level.INFO, "Finish meta data export.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void generate(GenerationProperties parameters) {
        Framework osgiContainer = null;
        File tempDirectory = null;
        try {
            tempDirectory = LQMG.createTempDirectory();
            osgiContainer = LQMG.startOSGiContainer(parameters.bundleLocations, tempDirectory.getAbsolutePath());
            List bundleResources = LiquibaseOSGiUtil.findBundlesBySchemaExpression((String)parameters.capability, (BundleContext)osgiContainer.getBundleContext(), (int)4);
            if (bundleResources.size() == 0) {
                if (parameters.hackWires) {
                    LOGGER.info("No matching bundle found. Trying to find unresolved bundles and hack their wires.");
                    frameworkUtil.hackBundles(osgiContainer, tempDirectory);
                    FrameworkWiring frameworkWiring = (FrameworkWiring)osgiContainer.adapt(FrameworkWiring.class);
                    frameworkWiring.resolveBundles(null);
                    bundleResources = LiquibaseOSGiUtil.findBundlesBySchemaExpression((String)parameters.capability, (BundleContext)osgiContainer.getBundleContext(), (int)4);
                } else {
                    LOGGER.severe("No matching bundle found. Probably setting hackWires to true would help");
                }
                if (bundleResources.size() == 0) {
                    LQMG.throwCapabilityNotFound(parameters, osgiContainer);
                }
            }
            LQMG.checkMatchingBundleResourceSize(parameters, bundleResources);
            BundleResource bundleResource = (BundleResource)bundleResources.get(0);
            LQMG.tryCodeGeneration(parameters, bundleResource.bundle, bundleResource.attributes);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Could not create temp directory", e);
            LQMG.stopFramework(osgiContainer);
            LQMG.deleteFolder(tempDirectory);
            return;
        }
        catch (BundleException e2) {
            LOGGER.log(Level.SEVERE, "Could not start embedded OSGi framework", e2);
            {
                catch (Throwable throwable) {
                    LQMG.stopFramework(osgiContainer);
                    LQMG.deleteFolder(tempDirectory);
                    throw throwable;
                }
            }
            LQMG.stopFramework(osgiContainer);
            LQMG.deleteFolder(tempDirectory);
        }
        LQMG.stopFramework(osgiContainer);
        LQMG.deleteFolder(tempDirectory);
    }

    private static void logUnresolvedBundles(Framework osgiContainer) {
        Bundle[] bundles;
        BundleContext systemBundleContext = osgiContainer.getBundleContext();
        for (Bundle bundle : bundles = systemBundleContext.getBundles()) {
            if (bundle.getState() != 2) continue;
            try {
                bundle.start();
            }
            catch (BundleException e) {
                LOGGER.log(Level.WARNING, "The bundle " + bundle.toString() + " could not be resolved", e);
            }
        }
    }

    private static void resetFrameworkProperties() {
        Class<FrameworkProperties> clazz = FrameworkProperties.class;
        try {
            Field propertiesField = clazz.getDeclaredField("properties");
            propertiesField.setAccessible(true);
            propertiesField.set(null, null);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static Framework startOSGiContainer(String[] bundleLocations, String tempDirPath) throws BundleException {
        FrameworkFactory frameworkFactory = ServiceLoader.load(FrameworkFactory.class).iterator().next();
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("osgi.configuration.area", tempDirPath);
        config.put("osgi.baseConfiguration.area", tempDirPath);
        config.put("osgi.sharedConfiguration.area", tempDirPath);
        config.put("osgi.instance.area", tempDirPath);
        config.put("osgi.user.area", tempDirPath);
        config.put("osgi.hook.configurators.exclude", "org.eclipse.core.runtime.internal.adaptor.EclipseLogHook");
        LQMG.resetFrameworkProperties();
        Framework framework = frameworkFactory.newFramework(config);
        framework.start();
        BundleContext systemBundleContext = framework.getBundleContext();
        for (String bundleLocation : bundleLocations) {
            try {
                systemBundleContext.installBundle(bundleLocation);
            }
            catch (BundleException e) {
                LOGGER.log(Level.WARNING, "Could not start bundle " + bundleLocation, e);
            }
        }
        FrameworkWiring frameworkWiring = (FrameworkWiring)framework.adapt(FrameworkWiring.class);
        frameworkWiring.resolveBundles(null);
        return framework;
    }

    private static void stopFramework(Framework osgiContainer) {
        if (osgiContainer != null) {
            try {
                osgiContainer.stop();
                osgiContainer.waitForStop(0L);
            }
            catch (BundleException e) {
                LOGGER.log(Level.SEVERE, "Could not stop embedded OSGi container during code generation", e);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.SEVERE, "Stopping of embedded OSGi container was interrupted", e);
                Thread.currentThread().interrupt();
            }
        }
    }

    private static void throwCapabilityNotFound(GenerationProperties parameters, Framework osgiContainer) {
        LQMG.logUnresolvedBundles(osgiContainer);
        throw new LQMGException("Could not find matching capability in any of the bundles for schema expression: " + parameters.capability, null);
    }

    private static void tryCodeGeneration(GenerationProperties parameters, Bundle bundle, Map<String, Object> bundleCapabilityAttributes) {
        LOGGER.log(Level.INFO, "Load driver.");
        Driver h2Driver = Driver.load();
        LOGGER.log(Level.INFO, "Loaded driver.");
        Connection connection = null;
        try {
            LOGGER.log(Level.INFO, "Creating connection.");
            String defaultSchema = parameters.defaultSchema;
            String jdbcURL = LQMG.createDataBaseURL(defaultSchema);
            connection = h2Driver.connect(jdbcURL, new Properties());
            LOGGER.log(Level.INFO, "Created connection.");
            LOGGER.log(Level.INFO, "Get database.");
            H2Database database = new H2Database();
            database.setCaseSensitive(Boolean.valueOf(true));
            database.setObjectQuotingStrategy(ObjectQuotingStrategy.QUOTE_ALL_OBJECTS);
            database.setLiquibaseSchemaName("PUBLIC");
            if (defaultSchema != null) {
                database.setDefaultSchemaName(defaultSchema);
            }
            database.setConnection((DatabaseConnection)new JdbcConnection(connection));
            LOGGER.log(Level.INFO, "Start LiquiBase and update.");
            EOSGiResourceAccessor resourceAccessor = new EOSGiResourceAccessor(bundle, bundleCapabilityAttributes);
            String schemaResource = (String)bundleCapabilityAttributes.get("resource");
            Liquibase liquibase = new Liquibase(schemaResource, (ResourceAccessor)resourceAccessor, (Database)database);
            ConfigurationContainer configContainer = new ConfigurationContainer();
            if (parameters.configurationPath != null) {
                configContainer.addConfiguration(new ConfigPath(null, parameters.configurationPath));
            }
            LQMGChangeExecListener lqmgChangeExecListener = new LQMGChangeExecListener(configContainer);
            liquibase.setChangeExecListener((ChangeExecListener)lqmgChangeExecListener);
            liquibase.update((String)null);
            LOGGER.log(Level.INFO, "Finish LiquiBase and update.");
            LQMG.exportMetaData(parameters, connection, configContainer);
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new LQMGException("Error during try to connection the database.", e);
        }
        catch (LiquibaseException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new LQMGException("Error during processing XML file; " + parameters.capability, e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                    LOGGER.log(Level.INFO, "Connection closed.");
                }
                catch (SQLException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    throw new LQMGException("Closing the connection was unsuccessful.", e);
                }
            }
        }
    }

    private LQMG() {
    }
}

