/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.spatial.jts;

import com.querydsl.core.types.ConstantImpl;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Visitor;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.spatial.SpatialOps;
import com.querydsl.spatial.jts.JTSGeometryExpression;
import com.querydsl.spatial.jts.JTSGeometryOperation;
import com.querydsl.spatial.jts.JTSLineStringExpression;
import com.querydsl.spatial.jts.JTSLineStringOperation;
import com.querydsl.spatial.jts.JTSPointExpression;
import com.querydsl.spatial.jts.JTSPointOperation;
import com.querydsl.spatial.jts.JTSPolygonExpression;
import com.querydsl.spatial.jts.JTSPolygonOperation;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;

public final class JTSGeometryExpressions {
    private JTSGeometryExpressions() {
    }

    public static StringExpression asEWKT(JTSGeometryExpression<?> expr) {
        return Expressions.stringOperation((Operator)SpatialOps.AS_EWKT, (Expression[])new Expression[]{expr});
    }

    public static JTSGeometryExpression<?> fromText(String text) {
        return JTSGeometryExpressions.geometryOperation(SpatialOps.GEOM_FROM_TEXT, new Expression[]{ConstantImpl.create((Object)text)});
    }

    public static JTSGeometryExpression<?> fromText(Expression<String> text) {
        return JTSGeometryExpressions.geometryOperation(SpatialOps.GEOM_FROM_TEXT, text);
    }

    public static <T extends Geometry> JTSGeometryExpression<T> setSRID(Expression<T> expr, int srid) {
        return JTSGeometryExpressions.geometryOperation(expr.getType(), SpatialOps.SET_SRID, new Expression[]{expr, ConstantImpl.create((int)srid)});
    }

    public static NumberExpression<Double> xmin(JTSGeometryExpression<?> expr) {
        return Expressions.numberOperation(Double.class, (Operator)SpatialOps.XMIN, (Expression[])new Expression[]{expr});
    }

    public static NumberExpression<Double> xmax(JTSGeometryExpression<?> expr) {
        return Expressions.numberOperation(Double.class, (Operator)SpatialOps.XMAX, (Expression[])new Expression[]{expr});
    }

    public static NumberExpression<Double> ymin(JTSGeometryExpression<?> expr) {
        return Expressions.numberOperation(Double.class, (Operator)SpatialOps.YMIN, (Expression[])new Expression[]{expr});
    }

    public static NumberExpression<Double> ymax(JTSGeometryExpression<?> expr) {
        return Expressions.numberOperation(Double.class, (Operator)SpatialOps.YMAX, (Expression[])new Expression[]{expr});
    }

    public static BooleanExpression dwithin(Expression<? extends Geometry> expr1, Expression<? extends Geometry> expr2, Expression<Double> distance) {
        return Expressions.booleanOperation((Operator)SpatialOps.DWITHIN, (Expression[])new Expression[]{expr1, expr2, distance});
    }

    public static BooleanExpression dwithin(Expression<? extends Geometry> expr1, Expression<? extends Geometry> expr2, double distance) {
        return Expressions.booleanOperation((Operator)SpatialOps.DWITHIN, (Expression[])new Expression[]{expr1, expr2, ConstantImpl.create((Object)distance)});
    }

    public static JTSGeometryExpression<?> extent(Expression<? extends GeometryCollection> collection) {
        return JTSGeometryExpressions.geometryOperation(SpatialOps.EXTENT, collection);
    }

    public static JTSGeometryExpression<?> collect(Expression<? extends GeometryCollection> collection) {
        return JTSGeometryExpressions.geometryOperation(SpatialOps.COLLECT, collection);
    }

    public static JTSGeometryExpression<?> collect(Expression<? extends Geometry> expr1, Expression<? extends Geometry> expr2) {
        return JTSGeometryExpressions.geometryOperation(SpatialOps.COLLECT2, expr1, expr2);
    }

    public static <T extends Geometry> JTSGeometryExpression<T> translate(Expression<T> expr, float deltax, float deltay) {
        return JTSGeometryExpressions.geometryOperation(expr.getType(), SpatialOps.TRANSLATE, new Expression[]{expr, ConstantImpl.create((Object)Float.valueOf(deltax)), ConstantImpl.create((Object)Float.valueOf(deltay))});
    }

    public static <T extends Geometry> JTSGeometryExpression<T> translate(Expression<T> expr, float deltax, float deltay, float deltaz) {
        return JTSGeometryExpressions.geometryOperation(expr.getType(), SpatialOps.TRANSLATE2, new Expression[]{expr, ConstantImpl.create((Object)Float.valueOf(deltax)), ConstantImpl.create((Object)Float.valueOf(deltay)), ConstantImpl.create((Object)Float.valueOf(deltaz))});
    }

    public static JTSGeometryExpression<Geometry> geometryOperation(Operator op, Expression<?> ... args) {
        return new JTSGeometryOperation<Geometry>(Geometry.class, op, args);
    }

    public static <T extends Geometry> JTSGeometryExpression<T> geometryOperation(Class<? extends T> type, Operator op, Expression<?> ... args) {
        return new JTSGeometryOperation<T>(type, op, args);
    }

    public static JTSLineStringExpression<LineString> lineStringOperation(Operator op, Expression<?> ... args) {
        return new JTSLineStringOperation<LineString>(LineString.class, op, args);
    }

    public static JTSPointExpression<Point> pointOperation(Operator op, Expression<?> ... args) {
        return new JTSPointOperation<Point>(Point.class, op, args);
    }

    public static JTSPolygonExpression<Polygon> polygonOperation(Operator op, Expression<?> ... args) {
        return new JTSPolygonOperation<Polygon>(Polygon.class, op, args);
    }

    public static <T extends Geometry> JTSGeometryExpression<T> asJTSGeometry(Expression<T> expr) {
        Expression underlyingMixin = ExpressionUtils.extract(expr);
        return new JTSGeometryExpression<T>(underlyingMixin){
            private static final long serialVersionUID = -6714044005570420009L;

            public <R, C> R accept(Visitor<R, C> v, C context) {
                return (R)this.mixin.accept(v, context);
            }
        };
    }

    public static <T extends Geometry> JTSGeometryExpression<T> asJTSGeometry(T value) {
        return JTSGeometryExpressions.asJTSGeometry(Expressions.constant(value));
    }
}

