/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import org.geolatte.geom.DimensionalFlag;
import org.geolatte.geom.Point;
import org.geolatte.geom.PointEquality;

abstract class AbstractPointEquality
implements PointEquality {
    private final DimensionalFlag dimensionalFlag;

    public AbstractPointEquality(DimensionalFlag dimensionalFlag) {
        this.dimensionalFlag = dimensionalFlag;
    }

    @Override
    public boolean equals(Point first, Point second) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (first.isEmpty() && second.isEmpty()) {
            return true;
        }
        if (first.isEmpty() || second.isEmpty()) {
            return false;
        }
        if (!first.getCrsId().equals(second.getCrsId())) {
            return false;
        }
        if (!this.equals(first.getX(), second.getX())) {
            return false;
        }
        if (!this.equals(first.getY(), second.getY())) {
            return false;
        }
        if (this.dimensionalFlag.is3D() && (first.is3D() || second.is3D()) && !this.equals(first.getZ(), second.getZ())) {
            return false;
        }
        return !this.dimensionalFlag.isMeasured() || !first.isMeasured() && !second.isMeasured() || this.equals(first.getM(), second.getM());
    }

    @Override
    public boolean equals(double[] first, DimensionalFlag df1, double[] second, DimensionalFlag df2) {
        if (first == null || df1 == null || second == null || df2 == null) {
            throw new IllegalArgumentException("Null objects not allowed here.");
        }
        if (first.length < df1.getCoordinateDimension() || second.length < df2.getCoordinateDimension()) {
            throw new IllegalArgumentException("Coordinate arrays are inconsistent with passed dimensional flags.");
        }
        if (!this.equals(first[0], second[0])) {
            return false;
        }
        if (!this.equals(first[1], second[1])) {
            return false;
        }
        if (this.dimensionalFlag.is3D() && (df1.is3D() || df2.is3D()) && !this.equals(this.get(first, df1.Z), this.get(second, df2.Z))) {
            return false;
        }
        return !this.dimensionalFlag.isMeasured() || !df1.isMeasured() && !df2.isMeasured() || this.equals(this.get(first, df1.M), this.get(second, df2.M));
    }

    protected double get(double[] coordinates, int index) {
        if (index == -1 || index >= coordinates.length) {
            return Double.NaN;
        }
        return coordinates[index];
    }

    protected DimensionalFlag getDimensionalFlag() {
        return this.dimensionalFlag;
    }

    protected abstract boolean equals(double var1, double var3);
}

