/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.crs;

import java.util.Arrays;
import org.geolatte.geom.crs.CrsId;
import org.geolatte.geom.crs.CrsIdentifiable;
import org.geolatte.geom.crs.Ellipsoid;

public class Datum
extends CrsIdentifiable {
    private final Ellipsoid ellipsoid;
    private final double[] toWGS84;

    public Datum(CrsId crsId, Ellipsoid ellipsoid, String name, double[] toWGS84) {
        super(crsId, name);
        this.ellipsoid = ellipsoid;
        this.toWGS84 = toWGS84 == null ? new double[]{} : toWGS84;
    }

    public Ellipsoid getEllipsoid() {
        return this.ellipsoid;
    }

    public double[] getToWGS84() {
        return this.toWGS84;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Datum that = (Datum)o;
        if (this.ellipsoid != null ? !this.ellipsoid.equals(that.ellipsoid) : that.ellipsoid != null) {
            return false;
        }
        return Arrays.equals(this.toWGS84, that.toWGS84);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.ellipsoid != null ? this.ellipsoid.hashCode() : 0);
        result = 31 * result + (this.toWGS84 != null ? Arrays.hashCode(this.toWGS84) : 0);
        return result;
    }
}

