/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.jts;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import org.geolatte.geom.DimensionalFlag;
import org.geolatte.geom.PointSequenceBuilder;
import org.geolatte.geom.PointSequenceBuilders;
import org.geolatte.geom.crs.CrsId;
import org.geolatte.geom.jts.DimensionalCoordinate;

class PointSequenceCoordinateSequenceFactory
implements CoordinateSequenceFactory {
    PointSequenceCoordinateSequenceFactory() {
    }

    public CoordinateSequence create(Coordinate[] coordinates) {
        DimensionalFlag flag = this.determineDimensionFlag(coordinates);
        return this.fromCoordinateArray(coordinates, flag, CrsId.UNDEFINED);
    }

    public CoordinateSequence create(CoordinateSequence coordSeq) {
        return coordSeq;
    }

    public CoordinateSequence create(int size, int dimension) {
        throw new UnsupportedOperationException();
    }

    private DimensionalFlag determineDimensionFlag(Coordinate[] coordinates) {
        if (coordinates == null || coordinates.length == 0) {
            return DimensionalFlag.d2D;
        }
        if (coordinates[0] instanceof DimensionalCoordinate) {
            return ((DimensionalCoordinate)coordinates[0]).getDimensionalFlag();
        }
        if (Double.isNaN(coordinates[0].z)) {
            return DimensionalFlag.d2D;
        }
        return DimensionalFlag.d3D;
    }

    private CoordinateSequence fromCoordinateArray(Coordinate[] coordinates, DimensionalFlag dim, CrsId crsId) {
        PointSequenceBuilder builder = PointSequenceBuilders.fixedSized(coordinates.length, dim, crsId);
        double[] ordinates = new double[dim.getCoordinateDimension()];
        for (Coordinate co : coordinates) {
            this.copy(co, ordinates, dim);
            builder.add(ordinates);
        }
        return (CoordinateSequence)builder.toPointSequence();
    }

    private void copy(Coordinate co, double[] ordinates, DimensionalFlag flag) {
        ordinates[flag.X] = co.x;
        ordinates[flag.Y] = co.y;
        if (flag.is3D()) {
            ordinates[flag.Z] = co.z;
        }
        if (flag.isMeasured()) {
            ordinates[flag.M] = co instanceof DimensionalCoordinate ? ((DimensionalCoordinate)co).m : Double.NaN;
        }
    }
}

