/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import liquibase.change.AbstractChange;
import liquibase.change.ChangeStatus;
import liquibase.change.ChangeWithColumns;
import liquibase.change.CheckSum;
import liquibase.change.ColumnConfig;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.core.LoadDataColumnConfig;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.Warnings;
import liquibase.io.EmptyLineAndCommentSkippingInputStream;
import liquibase.logging.LogFactory;
import liquibase.logging.Logger;
import liquibase.resource.ResourceAccessor;
import liquibase.resource.UtfBomAwareReader;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.InsertExecutablePreparedStatement;
import liquibase.statement.SequenceNextValueFunction;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.InsertOrUpdateStatement;
import liquibase.statement.core.InsertSetStatement;
import liquibase.statement.core.InsertStatement;
import liquibase.structure.core.Column;
import liquibase.util.BooleanParser;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtils;
import liquibase.util.csv.CSVReader;

@DatabaseChange(name="loadData", description="Loads data from a CSV file into an existing table. A value of NULL in a cell will be converted to a database NULL rather than the string 'NULL'\nLines starting with # (hash) sign are treated as comments. You can change comment pattern by specifying 'commentLineStartsWith' property in loadData tag.To disable comments set 'commentLineStartsWith' to empty value'\n\nDate/Time values included in the CSV file should be in ISO formathttp://en.wikipedia.org/wiki/ISO_8601 in order to be parsed correctly by Liquibase. Liquibase will initially set the date format to be 'yyyy-MM-dd'T'HH:mm:ss' and then it checks for two special cases which will override the data format string.\n\nIf the string representing the date/time includes a '.', then the date format is changed to 'yyyy-MM-dd'T'HH:mm:ss.SSS'\nIf the string representing the date/time includes a space, then the date format is changed to 'yyyy-MM-dd HH:mm:ss'\nOnce the date format string is set, Liquibase will then call the SimpleDateFormat.parse() method attempting to parse the input string so that it can return a Date/Time. If problems occur, then a ParseException is thrown and the input string is treated as a String for the INSERT command to be generated.", priority=1, appliesTo={"table"}, since="1.7")
public class LoadDataChange
extends AbstractChange
implements ChangeWithColumns<LoadDataColumnConfig> {
    public static final String DEFAULT_COMMENT_PATTERN = "#";
    private String catalogName;
    private String schemaName;
    private String tableName;
    private String file;
    private String commentLineStartsWith = "#";
    private Boolean relativeToChangelogFile;
    private String encoding = null;
    private String separator = ",";
    private String quotchar = "\"";
    private List<LoadDataColumnConfig> columns = new ArrayList<LoadDataColumnConfig>();

    @Override
    public boolean supports(Database database) {
        return true;
    }

    @Override
    public boolean generateRollbackStatementsVolatile(Database database) {
        return true;
    }

    @DatabaseChangeProperty(mustEqualExisting="table.catalog", since="3.0")
    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    @DatabaseChangeProperty(mustEqualExisting="table.schema")
    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @DatabaseChangeProperty(mustEqualExisting="table", description="Name of the table to insert data into", requiredForDatabase={"all"})
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @DatabaseChangeProperty(description="CSV file to load", exampleValue="com/example/users.csv", requiredForDatabase={"all"})
    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getCommentLineStartsWith() {
        return this.commentLineStartsWith;
    }

    public void setCommentLineStartsWith(String commentLineStartsWith) {
        this.commentLineStartsWith = commentLineStartsWith == null ? DEFAULT_COMMENT_PATTERN : (commentLineStartsWith.equals("") ? null : commentLineStartsWith);
    }

    public Boolean isRelativeToChangelogFile() {
        return this.relativeToChangelogFile;
    }

    public void setRelativeToChangelogFile(Boolean relativeToChangelogFile) {
        this.relativeToChangelogFile = relativeToChangelogFile;
    }

    @DatabaseChangeProperty(exampleValue="UTF-8", description="Encoding of the CSV file (defaults to UTF-8)")
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @DatabaseChangeProperty(exampleValue=",")
    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        if (separator != null && separator.equals("\\t")) {
            separator = "\t";
        }
        this.separator = separator;
    }

    @DatabaseChangeProperty(exampleValue="'")
    public String getQuotchar() {
        return this.quotchar;
    }

    public void setQuotchar(String quotchar) {
        this.quotchar = quotchar;
    }

    @Override
    public void addColumn(LoadDataColumnConfig column) {
        this.columns.add(column);
    }

    @Override
    @DatabaseChangeProperty(description="Defines how the data should be loaded.", requiredForDatabase={"all"})
    public List<LoadDataColumnConfig> getColumns() {
        return this.columns;
    }

    @Override
    public void setColumns(List<LoadDataColumnConfig> columns) {
        this.columns = columns;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SqlStatement[] generateStatements(Database database) {
        CSVReader reader = null;
        try {
            reader = this.getCSVReader();
            if (reader == null) {
                throw new UnexpectedLiquibaseException("Unable to read file " + this.getFile());
            }
            String[] headers = reader.readNext();
            if (headers == null) {
                throw new UnexpectedLiquibaseException("Data file " + this.getFile() + " was empty");
            }
            ArrayList<SqlStatement> statements = new ArrayList<SqlStatement>();
            boolean anyPreparedStatements = false;
            int lineNumber = 1;
            boolean isCommentingEnabled = StringUtils.isNotEmpty(this.commentLineStartsWith);
            while (true) {
                ArrayList<ColumnConfig> columns;
                boolean needsPreparedStatement2;
                String[] line;
                if ((line = reader.readNext()) != null) {
                    ++lineNumber;
                    if (line.length == 0 || line.length == 1 && StringUtils.trimToNull(line[0]) == null || isCommentingEnabled && this.isLineCommented(line)) continue;
                    if (line.length != headers.length) {
                        throw new UnexpectedLiquibaseException("CSV file " + this.getFile() + " Line " + lineNumber + " has " + line.length + " values defined, Header has " + headers.length + ". Numbers MUST be equal (check for unquoted string with embedded commas)");
                    }
                    needsPreparedStatement2 = false;
                    columns = new ArrayList<ColumnConfig>();
                } else {
                    if (anyPreparedStatements) {
                        SqlStatement[] needsPreparedStatement2 = statements.toArray(new SqlStatement[statements.size()]);
                        return needsPreparedStatement2;
                    }
                    InsertSetStatement statementSet = this.createStatementSet(this.getCatalogName(), this.getSchemaName(), this.getTableName());
                    for (SqlStatement stmt : statements) {
                        statementSet.addInsertStatement((InsertStatement)stmt);
                    }
                    if (database instanceof MSSQLDatabase || database instanceof MySQLDatabase || database instanceof PostgresDatabase) {
                        List<InsertStatement> innerStatements = statementSet.getStatements();
                        if (innerStatements != null && innerStatements.size() > 0 && innerStatements.get(0) instanceof InsertOrUpdateStatement) {
                            SqlStatement[] stmt = statementSet.getStatementsArray();
                            return stmt;
                        }
                        SqlStatement[] stmt = new SqlStatement[]{statementSet};
                        return stmt;
                    }
                    SqlStatement[] sqlStatementArray = statementSet.getStatementsArray();
                    return sqlStatementArray;
                }
                for (int i = 0; i < headers.length; ++i) {
                    ColumnConfig valueConfig;
                    block60: {
                        String columnName;
                        String value;
                        block61: {
                            ColumnConfig columnConfig;
                            block67: {
                                String sequenceName;
                                block66: {
                                    block65: {
                                        block64: {
                                            block63: {
                                                block62: {
                                                    value = line[i].trim();
                                                    columnName = headers[i].trim();
                                                    valueConfig = new ColumnConfig();
                                                    columnConfig = this.getColumnConfig(i, headers[i].trim());
                                                    if (columnConfig == null) break block61;
                                                    if ("skip".equalsIgnoreCase(columnConfig.getType())) continue;
                                                    if (columnConfig.getName() != null) {
                                                        columnName = columnConfig.getName();
                                                    }
                                                    valueConfig.setName(columnName);
                                                    if (columnConfig.getType() == null) break block60;
                                                    if (!columnConfig.getType().equalsIgnoreCase("BOOLEAN")) break block62;
                                                    if (value.toString().equalsIgnoreCase("NULL")) {
                                                        valueConfig.setValue(null);
                                                        break block60;
                                                    } else {
                                                        valueConfig.setValueBoolean(BooleanParser.parseBoolean(value.toString().toLowerCase()));
                                                    }
                                                    break block60;
                                                }
                                                if (!columnConfig.getType().equalsIgnoreCase("NUMERIC")) break block63;
                                                if (value.toString().equalsIgnoreCase("NULL")) {
                                                    valueConfig.setValue(null);
                                                    break block60;
                                                } else {
                                                    valueConfig.setValueNumeric(value.toString());
                                                }
                                                break block60;
                                            }
                                            if (!columnConfig.getType().toLowerCase().contains("date") && !columnConfig.getType().toLowerCase().contains("time")) break block64;
                                            if (value.toString().equalsIgnoreCase("NULL")) {
                                                valueConfig.setValue(null);
                                                break block60;
                                            } else {
                                                valueConfig.setValueDate(value.toString());
                                            }
                                            break block60;
                                        }
                                        if (!columnConfig.getType().equalsIgnoreCase("STRING")) break block65;
                                        if (value.toString().equalsIgnoreCase("NULL")) {
                                            valueConfig.setValue(null);
                                            break block60;
                                        } else {
                                            valueConfig.setValue(value.toString());
                                        }
                                        break block60;
                                    }
                                    if (!columnConfig.getType().equalsIgnoreCase("COMPUTED")) break block66;
                                    if (value.toString().equalsIgnoreCase("NULL")) {
                                        valueConfig.setValue(null);
                                        break block60;
                                    } else {
                                        DatabaseFunction function = new DatabaseFunction(value.toString());
                                        valueConfig.setValueComputed(function);
                                    }
                                    break block60;
                                }
                                if (!columnConfig.getType().equalsIgnoreCase("SEQUENCE")) break block67;
                                if (value.toString().equalsIgnoreCase("NULL")) {
                                    sequenceName = columnConfig.getDefaultValue();
                                    if (sequenceName == null) {
                                        throw new UnexpectedLiquibaseException("Must set a sequence name in the loadData column defaultValue attribute");
                                    }
                                } else {
                                    sequenceName = value.toString();
                                }
                                SequenceNextValueFunction function = new SequenceNextValueFunction(sequenceName);
                                valueConfig.setValueComputed(function);
                                break block60;
                            }
                            if (columnConfig.getType().equalsIgnoreCase("BLOB")) {
                                if (value.toString().equalsIgnoreCase("NULL")) {
                                    valueConfig.setValue(null);
                                    break block60;
                                } else {
                                    valueConfig.setValueBlobFile(value.toString());
                                    needsPreparedStatement2 = true;
                                }
                                break block60;
                            } else {
                                if (!columnConfig.getType().equalsIgnoreCase("CLOB")) throw new UnexpectedLiquibaseException("loadData type of " + columnConfig.getType() + " is not supported.  Please use BOOLEAN, NUMERIC, DATE, STRING, COMPUTED, SEQUENCE or SKIP");
                                if (value.toString().equalsIgnoreCase("NULL")) {
                                    valueConfig.setValue(null);
                                    break block60;
                                } else {
                                    valueConfig.setValueClobFile(value.toString());
                                    needsPreparedStatement2 = true;
                                }
                            }
                            break block60;
                        }
                        if (columnName.contains("(") || columnName.contains(")") && database instanceof AbstractJdbcDatabase) {
                            columnName = ((AbstractJdbcDatabase)database).quoteObject(columnName, Column.class);
                        }
                        valueConfig.setName(columnName);
                        if (value == null || value.toString().equalsIgnoreCase("NULL")) {
                            valueConfig.setValue(value);
                        } else {
                            valueConfig.setValue(value.toString());
                        }
                    }
                    columns.add(valueConfig);
                }
                if (needsPreparedStatement2) {
                    anyPreparedStatements = true;
                    statements.add(new InsertExecutablePreparedStatement(database, this.getCatalogName(), this.getSchemaName(), this.getTableName(), columns, this.getChangeSet(), this.getResourceAccessor()));
                    continue;
                }
                InsertStatement insertStatement = this.createStatement(this.getCatalogName(), this.getSchemaName(), this.getTableName());
                for (ColumnConfig column : columns) {
                    String columnName = column.getName();
                    Object value = column.getValueObject();
                    if (value == null) {
                        value = "NULL";
                    }
                    insertStatement.addColumnValue(columnName, value);
                }
                statements.add(insertStatement);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (UnexpectedLiquibaseException ule) {
            if (this.getChangeSet() == null) throw ule;
            if (this.getChangeSet().getFailOnError() == null) throw ule;
            if (this.getChangeSet().getFailOnError() != false) throw ule;
            Logger log = LogFactory.getLogger();
            log.info("Change set " + this.getChangeSet().toString(false) + " failed, but failOnError was false.  Error: " + ule.getMessage());
            SqlStatement[] sqlStatementArray = new SqlStatement[]{};
            return sqlStatementArray;
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private boolean isLineCommented(String[] line) {
        return StringUtils.startsWith(line[0], this.commentLineStartsWith);
    }

    @Override
    public boolean generateStatementsVolatile(Database database) {
        return true;
    }

    public CSVReader getCSVReader() throws IOException {
        ResourceAccessor resourceAccessor = this.getResourceAccessor();
        if (resourceAccessor == null) {
            throw new UnexpectedLiquibaseException("No file resourceAccessor specified for " + this.getFile());
        }
        InputStream stream = StreamUtil.openStream(this.file, this.isRelativeToChangelogFile(), this.getChangeSet(), resourceAccessor);
        if (stream == null) {
            return null;
        }
        UtfBomAwareReader streamReader = this.getEncoding() == null ? new UtfBomAwareReader(stream) : new UtfBomAwareReader(stream, this.getEncoding());
        char quotchar = StringUtils.trimToEmpty(this.quotchar).length() == 0 ? (char)'\u0001' : this.quotchar.charAt(0);
        if (this.separator == null) {
            this.separator = ",";
        }
        return new CSVReader((Reader)streamReader, this.separator.charAt(0), quotchar);
    }

    protected InsertStatement createStatement(String catalogName, String schemaName, String tableName) {
        return new InsertStatement(catalogName, schemaName, tableName);
    }

    protected InsertSetStatement createStatementSet(String catalogName, String schemaName, String tableName) {
        return new InsertSetStatement(catalogName, schemaName, tableName);
    }

    protected ColumnConfig getColumnConfig(int index, String header) {
        for (LoadDataColumnConfig config : this.columns) {
            if (config.getIndex() != null && config.getIndex().equals(index)) {
                return config;
            }
            if (config.getHeader() != null && config.getHeader().equalsIgnoreCase(header)) {
                return config;
            }
            if (config.getName() == null || !config.getName().equalsIgnoreCase(header)) continue;
            return config;
        }
        return null;
    }

    @Override
    public ChangeStatus checkStatus(Database database) {
        return new ChangeStatus().unknown("Cannot check loadData status");
    }

    @Override
    public String getConfirmationMessage() {
        return "Data loaded from " + this.getFile() + " into " + this.getTableName();
    }

    @Override
    public CheckSum generateCheckSum() {
        InputStream stream = null;
        try {
            stream = StreamUtil.openStream(this.file, this.isRelativeToChangelogFile(), this.getChangeSet(), this.getResourceAccessor());
            if (stream == null) {
                throw new UnexpectedLiquibaseException(this.getFile() + " could not be found");
            }
            stream = new EmptyLineAndCommentSkippingInputStream(stream, this.commentLineStartsWith);
            CheckSum checkSum = CheckSum.compute(this.getTableName() + ":" + CheckSum.compute(stream, true));
            return checkSum;
        }
        catch (IOException e) {
            throw new UnexpectedLiquibaseException(e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    @Override
    public Warnings warn(Database database) {
        return null;
    }

    @Override
    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/dbchangelog";
    }
}

