/*
 * Decompiled with CFR 0.152.
 */
package liquibase.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import liquibase.util.StringUtils;

public class EmptyLineAndCommentSkippingInputStream
extends BufferedInputStream {
    public static final int MAX_CHAR_SIZE_IN_BYTES = 4;
    public static final int MAX_NEW_LINE_CHARS = 2;
    private final String commentLineStartsWith;
    private final boolean commentSkipEnabled;
    private final int commentLineStartsWithLength;

    public EmptyLineAndCommentSkippingInputStream(InputStream in, String commentLineStartsWith) {
        super(in);
        this.commentLineStartsWith = commentLineStartsWith;
        this.commentSkipEnabled = StringUtils.isNotEmpty(commentLineStartsWith);
        this.commentLineStartsWithLength = this.commentSkipEnabled ? commentLineStartsWith.length() : -1;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.isPositionAtStart() || this.skipIfNewLine()) {
            this.skipCommentsAndNewLines();
        }
        return super.read();
    }

    private boolean isPositionAtStart() {
        return this.pos == 0;
    }

    private void skipCommentsAndNewLines() throws IOException {
        while (this.skipLineIfItsCommented() || this.skipIfNewLine()) {
        }
    }

    private boolean skipIfNewLine() throws IOException {
        this.mark(4);
        int char1 = super.read();
        if (char1 != 13 && char1 != 10) {
            this.reset();
            return false;
        }
        this.mark(4);
        int char2 = super.read();
        if (char2 == 10) {
            return true;
        }
        this.reset();
        return true;
    }

    private boolean skipLineIfItsCommented() throws IOException {
        if (!this.commentSkipEnabled) {
            return false;
        }
        this.mark(this.commentLineStartsWithLength * 4);
        for (int i = 0; i < this.commentLineStartsWithLength; ++i) {
            if (this.commentLineStartsWith.charAt(i) == super.read()) continue;
            this.reset();
            return false;
        }
        this.readUntilEndOfLine();
        return true;
    }

    private void readUntilEndOfLine() throws IOException {
        while (!this.skipIfNewLine()) {
            super.read();
        }
    }
}

