/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import java.util.ArrayList;
import java.util.List;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.parser.ChangeLogParserCofiguration;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.core.CreateProcedureStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.structure.core.StoredProcedure;
import liquibase.util.SqlParser;
import liquibase.util.StringClauses;
import liquibase.util.StringUtils;

public class CreateProcedureGenerator
extends AbstractSqlGenerator<CreateProcedureStatement> {
    @Override
    public ValidationErrors validate(CreateProcedureStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("procedureText", statement.getProcedureText());
        if (statement.getReplaceIfExists() != null) {
            if (database instanceof MSSQLDatabase) {
                if (statement.getReplaceIfExists().booleanValue() && statement.getProcedureName() == null) {
                    validationErrors.addError("procedureName is required if replaceIfExists = true");
                }
            } else {
                validationErrors.checkDisallowedField("replaceIfExists", statement.getReplaceIfExists(), null, new Class[0]);
            }
        }
        return validationErrors;
    }

    @Override
    public Sql[] generateSql(CreateProcedureStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ArrayList<Sql> sql = new ArrayList<Sql>();
        String schemaName = statement.getSchemaName();
        if (schemaName == null) {
            schemaName = database.getDefaultSchemaName();
        }
        String procedureText = CreateProcedureGenerator.addSchemaToText(statement.getProcedureText(), schemaName, "PROCEDURE", database);
        if (statement.getReplaceIfExists() != null && statement.getReplaceIfExists().booleanValue()) {
            String fullyQualifiedName = database.escapeObjectName(statement.getProcedureName(), StoredProcedure.class);
            if (schemaName != null) {
                fullyQualifiedName = database.escapeObjectName(schemaName, Schema.class) + "." + fullyQualifiedName;
            }
            sql.add(new UnparsedSql("if object_id('" + fullyQualifiedName + "', 'p') is null exec ('create procedure " + fullyQualifiedName + " as select 1 a')", new DatabaseObject[0]));
            StringClauses parsedSql = SqlParser.parse(procedureText, true, true);
            StringClauses.ClauseIterator clauseIterator = parsedSql.getClauseIterator();
            Object next = "START";
            while (next != null && !next.toString().equalsIgnoreCase("create") && !next.toString().equalsIgnoreCase("alter") && clauseIterator.hasNext()) {
                next = clauseIterator.nextNonWhitespace();
            }
            clauseIterator.replace("ALTER");
            procedureText = parsedSql.toString();
        }
        sql.add(new UnparsedSql(procedureText, statement.getEndDelimiter(), new DatabaseObject[0]));
        CreateProcedureGenerator.surroundWithSchemaSets(sql, statement.getSchemaName(), database);
        return sql.toArray(new Sql[sql.size()]);
    }

    public static void surroundWithSchemaSets(List<Sql> sql, String schemaName, Database database) {
        if (StringUtils.trimToNull(schemaName) != null && !LiquibaseConfiguration.getInstance().getProperty(ChangeLogParserCofiguration.class, "useProcedureSchema").getValue(Boolean.class).booleanValue()) {
            String defaultSchema = database.getDefaultSchemaName();
            if (database instanceof OracleDatabase) {
                sql.add(0, new UnparsedSql("ALTER SESSION SET CURRENT_SCHEMA=" + schemaName, new DatabaseObject[0]));
                sql.add(new UnparsedSql("ALTER SESSION SET CURRENT_SCHEMA=" + defaultSchema, new DatabaseObject[0]));
            } else if (database instanceof DB2Database) {
                sql.add(0, new UnparsedSql("SET CURRENT SCHEMA " + schemaName, new DatabaseObject[0]));
                sql.add(new UnparsedSql("SET CURRENT SCHEMA " + defaultSchema, new DatabaseObject[0]));
            }
        }
    }

    public static String addSchemaToText(String procedureText, String schemaName, String keywordBeforeName, Database database) {
        if (StringUtils.trimToNull(schemaName) != null && LiquibaseConfiguration.getInstance().getProperty(ChangeLogParserCofiguration.class, "useProcedureSchema").getValue(Boolean.class).booleanValue()) {
            StringClauses parsedSql = SqlParser.parse(procedureText, true, true);
            StringClauses.ClauseIterator clauseIterator = parsedSql.getClauseIterator();
            Object next = "START";
            while (next != null && !next.toString().equalsIgnoreCase(keywordBeforeName) && clauseIterator.hasNext()) {
                next = clauseIterator.nextNonWhitespace();
            }
            if (next != null && clauseIterator.hasNext()) {
                Object procNameClause = clauseIterator.nextNonWhitespace();
                if (procNameClause instanceof String) {
                    String[] nameParts = ((String)procNameClause).split("\\.");
                    String finalName = nameParts.length == 1 ? database.escapeObjectName(schemaName, Schema.class) + "." + nameParts[0] : (nameParts.length == 2 ? database.escapeObjectName(schemaName, Schema.class) + "." + nameParts[1] : (nameParts.length == 3 ? nameParts[0] + "." + database.escapeObjectName(schemaName, Schema.class) + "." + nameParts[2] : (String)procNameClause));
                    clauseIterator.replace(finalName);
                }
                procedureText = parsedSql.toString();
            }
        }
        return procedureText;
    }
}

