/*
 * Decompiled with CFR 0.152.
 */
package org.everit.persistence.liquibase.ext.osgi.parser;

import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.exception.ChangeLogParseException;
import liquibase.exception.LiquibaseException;
import liquibase.osgi.OSGiResourceAccessor;
import liquibase.parser.ChangeLogParser;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.resource.ResourceAccessor;
import org.everit.persistence.liquibase.ext.osgi.EOSGiResourceAccessor;
import org.everit.persistence.liquibase.ext.osgi.util.BundleResource;
import org.everit.persistence.liquibase.ext.osgi.util.LiquibaseOSGiUtil;
import org.osgi.framework.Bundle;

public class EOSGiChangelogParser
implements ChangeLogParser {
    public int getPriority() {
        return 1;
    }

    public DatabaseChangeLog parse(String physicalChangeLogLocation, ChangeLogParameters changeLogParameters, ResourceAccessor resourceAccessor) throws ChangeLogParseException {
        String schemaExpression = physicalChangeLogLocation.substring(0, physicalChangeLogLocation.length() - ".osgi".length());
        if (!(resourceAccessor instanceof OSGiResourceAccessor)) {
            throw new IllegalArgumentException("type of resourceAccessor must be " + OSGiResourceAccessor.class.getName());
        }
        OSGiResourceAccessor osgiResourceAccessor = (OSGiResourceAccessor)resourceAccessor;
        Bundle currentBundle = osgiResourceAccessor.getBundle();
        BundleResource bundleResource = LiquibaseOSGiUtil.findMatchingWireBySchemaExpression(currentBundle, schemaExpression);
        if (bundleResource == null) {
            throw new ChangeLogParseException("Could not find resource starting from bundle '" + currentBundle + "' with schema expression '" + schemaExpression + "'");
        }
        OSGiResourceAccessor newOSGiResourceAccessor = osgiResourceAccessor;
        if (!currentBundle.equals(bundleResource.bundle)) {
            newOSGiResourceAccessor = new EOSGiResourceAccessor(bundleResource.bundle, bundleResource.attributes);
        }
        try {
            return ChangeLogParserFactory.getInstance().getParser(bundleResource.resourceName, (ResourceAccessor)newOSGiResourceAccessor).parse(bundleResource.resourceName, changeLogParameters, (ResourceAccessor)newOSGiResourceAccessor);
        }
        catch (LiquibaseException e) {
            throw new ChangeLogParseException((Throwable)e);
        }
    }

    public boolean supports(String changeLogFile, ResourceAccessor resourceAccessor) {
        return resourceAccessor instanceof OSGiResourceAccessor && changeLogFile.endsWith(".osgi");
    }
}

