/*
 * Decompiled with CFR 0.152.
 */
package org.everit.persistence.querydsl.ecm;

import com.querydsl.sql.CUBRIDTemplates;
import com.querydsl.sql.DerbyTemplates;
import com.querydsl.sql.H2Templates;
import com.querydsl.sql.HSQLDBTemplates;
import com.querydsl.sql.MySQLTemplates;
import com.querydsl.sql.OracleTemplates;
import com.querydsl.sql.PostgreSQLTemplates;
import com.querydsl.sql.SQLServer2005Templates;
import com.querydsl.sql.SQLServer2008Templates;
import com.querydsl.sql.SQLServer2012Templates;
import com.querydsl.sql.SQLServerTemplates;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.SQLiteTemplates;
import com.querydsl.sql.TeradataTemplates;
import org.everit.persistence.querydsl.ecm.UnknownDatabaseTypeException;

public enum DBMSType {
    CUBRID{

        @Override
        public String getProductName() {
            return DBMSType.TYPE_CUBRID;
        }

        @Override
        public SQLTemplates.Builder getSQLTemplatesBuilder() {
            return CUBRIDTemplates.builder();
        }
    }
    ,
    DERBY{

        @Override
        public String getProductName() {
            return "Apache Derby";
        }

        @Override
        public SQLTemplates.Builder getSQLTemplatesBuilder() {
            return DerbyTemplates.builder();
        }

        @Override
        public String toString() {
            return DBMSType.TYPE_DERBY;
        }
    }
    ,
    H2{

        @Override
        public String getProductName() {
            return DBMSType.TYPE_H2;
        }

        @Override
        public SQLTemplates.Builder getSQLTemplatesBuilder() {
            return H2Templates.builder();
        }
    }
    ,
    HSQLDB{

        @Override
        public String getProductName() {
            return "HSQL Database Engine";
        }

        @Override
        public SQLTemplates.Builder getSQLTemplatesBuilder() {
            return HSQLDBTemplates.builder();
        }

        @Override
        public String toString() {
            return DBMSType.TYPE_HSQLDB;
        }
    }
    ,
    MYSQL{

        @Override
        public String getProductName() {
            return DBMSType.TYPE_MYSQL;
        }

        @Override
        public SQLTemplates.Builder getSQLTemplatesBuilder() {
            return MySQLTemplates.builder();
        }
    }
    ,
    ORACLE{

        @Override
        public String getProductName() {
            return DBMSType.TYPE_ORACLE;
        }

        @Override
        public SQLTemplates.Builder getSQLTemplatesBuilder() {
            return OracleTemplates.builder();
        }
    }
    ,
    POSTGRES{

        @Override
        public String getProductName() {
            return "PostgreSQL";
        }

        @Override
        public SQLTemplates.Builder getSQLTemplatesBuilder() {
            return PostgreSQLTemplates.builder();
        }

        @Override
        public String toString() {
            return DBMSType.TYPE_POSTGRES;
        }
    }
    ,
    SQLITE{

        @Override
        public String getProductName() {
            return DBMSType.TYPE_SQLITE;
        }

        @Override
        public SQLTemplates.Builder getSQLTemplatesBuilder() {
            return SQLiteTemplates.builder();
        }
    }
    ,
    SQLSERVER{

        @Override
        boolean fitsMajorVersion(int majorVersion) {
            return majorVersion < 9;
        }

        @Override
        public String getProductName() {
            return "Microsoft SQL Server";
        }

        @Override
        public SQLTemplates.Builder getSQLTemplatesBuilder() {
            return SQLServerTemplates.builder();
        }

        @Override
        public String toString() {
            return DBMSType.TYPE_SQLSERVER;
        }
    }
    ,
    SQLSERVER_2005{

        @Override
        boolean fitsMajorVersion(int majorVersion) {
            return majorVersion == 9;
        }

        @Override
        public String getProductName() {
            return SQLSERVER.getProductName();
        }

        @Override
        public SQLTemplates.Builder getSQLTemplatesBuilder() {
            return SQLServer2005Templates.builder();
        }

        @Override
        public String toString() {
            return DBMSType.TYPE_SQLSERVER_2005;
        }
    }
    ,
    SQLSERVER_2008{

        @Override
        boolean fitsMajorVersion(int majorVersion) {
            return majorVersion == 10;
        }

        @Override
        public String getProductName() {
            return SQLSERVER.getProductName();
        }

        @Override
        public SQLTemplates.Builder getSQLTemplatesBuilder() {
            return SQLServer2008Templates.builder();
        }

        @Override
        public String toString() {
            return DBMSType.TYPE_SQLSERVER_2008;
        }
    }
    ,
    SQLSERVER_2012{

        @Override
        boolean fitsMajorVersion(int majorVersion) {
            return majorVersion > 10;
        }

        @Override
        public String getProductName() {
            return SQLSERVER.getProductName();
        }

        @Override
        public SQLTemplates.Builder getSQLTemplatesBuilder() {
            return SQLServer2012Templates.builder();
        }

        @Override
        public String toString() {
            return DBMSType.TYPE_SQLSERVER_2012;
        }
    }
    ,
    TERADATA{

        @Override
        public String getProductName() {
            return DBMSType.TYPE_TERADATA;
        }

        @Override
        public SQLTemplates.Builder getSQLTemplatesBuilder() {
            return TeradataTemplates.builder();
        }
    };

    public static final String TYPE_CUBRID = "CUBRID";
    public static final String TYPE_DERBY = "Derby";
    public static final String TYPE_H2 = "H2";
    public static final String TYPE_HSQLDB = "HSQLDB";
    public static final String TYPE_MYSQL = "MySQL";
    public static final String TYPE_ORACLE = "Oracle";
    public static final String TYPE_POSTGRES = "Postgres";
    public static final String TYPE_SQLITE = "SQLite";
    public static final String TYPE_SQLSERVER = "SQLServer";
    public static final String TYPE_SQLSERVER_2005 = "SQLServer2005";
    public static final String TYPE_SQLSERVER_2008 = "SQLServer2008";
    public static final String TYPE_SQLSERVER_2012 = "SQLServer2012";
    public static final String TYPE_TERADATA = "Teradata";
    private static final int VERSION_SQLSERVER_2005 = 9;
    private static final int VERSION_SQLSERVER_2008 = 10;

    public static DBMSType getByProductNameAndMajorVersion(String productName, int majorVersion) {
        for (DBMSType type : DBMSType.values()) {
            if (!type.getProductName().equals(productName) || !type.fitsMajorVersion(majorVersion)) continue;
            return type;
        }
        throw new UnknownDatabaseTypeException("database " + productName + " (major version: " + majorVersion + ") is not supported");
    }

    boolean fitsMajorVersion(int majorVersion) {
        return true;
    }

    public abstract String getProductName();

    public abstract SQLTemplates.Builder getSQLTemplatesBuilder();

    public String toString() {
        return this.getProductName();
    }
}

