/*
 * Decompiled with CFR 0.152.
 */
package org.everit.persistence.querydsl.ecm.internal;

import com.querydsl.sql.SQLTemplates;
import java.util.Hashtable;
import org.everit.osgi.ecm.annotation.Activate;
import org.everit.osgi.ecm.annotation.Deactivate;
import org.everit.osgi.ecm.annotation.attribute.BooleanAttribute;
import org.everit.osgi.ecm.annotation.attribute.CharacterAttribute;
import org.everit.osgi.ecm.annotation.attribute.StringAttribute;
import org.everit.osgi.ecm.annotation.attribute.StringAttributes;
import org.everit.osgi.ecm.component.ComponentContext;
import org.everit.persistence.querydsl.ecm.DBMSType;
import org.osgi.framework.ServiceRegistration;

@StringAttributes(value={@StringAttribute(attributeId="service.description", defaultValue={"Everit Querydsl SQLTemplates"}, priority=0.0f, label="Service description", description="The description of this component configuration. It is used to easily identify the service registered by this component.")})
public abstract class AbstractSQLTemplatesComponent {
    public static final int P_ESCAPE = 8;
    public static final int P_NEW_LINE_TO_SINGLE_SPACE = 7;
    public static final int P_PRINT_SCHEMA = 5;
    public static final int P_QUOTE = 6;
    public static final int P_SERVICE_DESCRIPTION = 0;
    private char escape;
    private boolean newLineToSingleSpace;
    private boolean printSchema;
    private boolean quote;
    private ServiceRegistration<?> serviceRegistration;

    @Activate
    public void activate(ComponentContext<?> componentContext) {
        DBMSType dbmsType = this.getDBMSType();
        SQLTemplates.Builder sqlTemplatesBuilder = dbmsType.getSQLTemplatesBuilder();
        sqlTemplatesBuilder.escape(this.escape);
        if (this.newLineToSingleSpace) {
            sqlTemplatesBuilder.newLineToSingleSpace();
        }
        if (this.printSchema) {
            sqlTemplatesBuilder.printSchema();
        }
        if (this.quote) {
            sqlTemplatesBuilder.quote();
        }
        SQLTemplates sqlTemplates = sqlTemplatesBuilder.build();
        Hashtable<String, String> serviceProperties = new Hashtable<String, String>(componentContext.getProperties());
        serviceProperties.put("dbType", dbmsType.toString());
        this.serviceRegistration = componentContext.registerService(SQLTemplates.class, (Object)sqlTemplates, serviceProperties);
    }

    @Deactivate
    public void deactivate() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }

    protected abstract DBMSType getDBMSType();

    @CharacterAttribute(attributeId="escape", defaultValue={92}, priority=8.0f, label="Escape character", description="Escape character.")
    public void setEscape(char escape) {
        this.escape = escape;
    }

    @BooleanAttribute(attributeId="newLineToSingleSpace", defaultValue={false}, priority=7.0f, label="New line to single space", description="Replaces new line characters with a single space.")
    public void setNewLineToSingleSpace(boolean newLineToSingleSpace) {
        this.newLineToSingleSpace = newLineToSingleSpace;
    }

    @BooleanAttribute(attributeId="printSchema", defaultValue={false}, priority=5.0f, label="Print schema", description="This property determines whether or not the SQLTemplate will insert the schema name before the table name in the SQL expressions. /select * from schemaname.tablename;/.")
    public void setPrintSchema(boolean printSchema) {
        this.printSchema = printSchema;
    }

    @BooleanAttribute(attributeId="quote", defaultValue={false}, priority=6.0f, label="Quote", description="This property determines whether or not the SQLTemplate will be quoting in SQL strings.")
    public void setQuote(boolean quote) {
        this.quote = quote;
    }
}

