/*
 * Decompiled with CFR 0.152.
 */
package org.everit.persistence.querydsl.ecm.internal;

import com.querydsl.sql.SQLTemplates;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.everit.osgi.ecm.annotation.Component;
import org.everit.osgi.ecm.annotation.ConfigurationPolicy;
import org.everit.osgi.ecm.annotation.ManualService;
import org.everit.osgi.ecm.annotation.ManualServices;
import org.everit.osgi.ecm.annotation.ServiceRef;
import org.everit.osgi.ecm.extender.ExtendComponent;
import org.everit.persistence.querydsl.ecm.DBMSType;
import org.everit.persistence.querydsl.ecm.internal.AbstractSQLTemplatesComponent;

@Component(componentId="org.everit.persistence.querydsl.ecm.AutoSQLTemplates", configurationPolicy=ConfigurationPolicy.FACTORY, label="Everit QueryDSL Auto SQLTemplates", description="By configuring this component, the user will get an SQLTemplate as an OSGi service.")
@ManualServices(value={@ManualService(value={SQLTemplates.class})})
@ExtendComponent
public class AutoSQLTemplatesComponent
extends AbstractSQLTemplatesComponent {
    public static final int P_DATA_SOURCE = 1;
    public static final int P_LOG_SERVICE = 10;
    private DataSource dataSource;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected DBMSType getDBMSType() {
        String dbProductName = "";
        int dbMajorVersion = 0;
        try (Connection conn = this.dataSource.getConnection();){
            dbProductName = conn.getMetaData().getDatabaseProductName();
            dbMajorVersion = conn.getMetaData().getDatabaseMajorVersion();
            DBMSType dBMSType = DBMSType.getByProductNameAndMajorVersion(dbProductName, dbMajorVersion);
            return dBMSType;
        }
        catch (SQLException e) {
            throw new IllegalStateException("Cannot get Database product name of the given DataSource.", e);
        }
    }

    @ServiceRef(attributeId="dataSource.target", defaultValue={""}, label="DataSource service filter", attributePriority=1.0f, description="An OSGi filter expression to select the right DataSource. The right QueryDSL SQLTemplate will be created based on this DataSource's Database type.")
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

