/*
 * Decompiled with CFR 0.152.
 */
package org.everit.persistence.querydsl.ecm.internal;

import com.querydsl.sql.Configuration;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.namemapping.NameMapping;
import java.util.Hashtable;
import java.util.Map;
import org.everit.osgi.ecm.annotation.Activate;
import org.everit.osgi.ecm.annotation.Component;
import org.everit.osgi.ecm.annotation.ConfigurationPolicy;
import org.everit.osgi.ecm.annotation.Deactivate;
import org.everit.osgi.ecm.annotation.ManualService;
import org.everit.osgi.ecm.annotation.ManualServices;
import org.everit.osgi.ecm.annotation.ServiceRef;
import org.everit.osgi.ecm.annotation.attribute.BooleanAttribute;
import org.everit.osgi.ecm.annotation.attribute.BooleanAttributes;
import org.everit.osgi.ecm.annotation.attribute.StringAttribute;
import org.everit.osgi.ecm.annotation.attribute.StringAttributes;
import org.everit.osgi.ecm.component.ComponentContext;
import org.everit.osgi.ecm.extender.ExtendComponent;
import org.osgi.framework.ServiceRegistration;

@Component(componentId="org.everit.persistence.querydsl.ecm.QuerydslConfiguration", configurationPolicy=ConfigurationPolicy.FACTORY, label="Everit Querydsl Configuration", description="Registers Querydsl Configuration instance as OSGi service.")
@BooleanAttributes(value={@BooleanAttribute(attributeId="useLiterals", defaultValue={false}, priority=2.0f, label="Use literals", description="Whether to use literals in SQL statements or not.")})
@StringAttributes(value={@StringAttribute(attributeId="service.description", defaultValue={"Everit Querydsl Configuration"}, priority=0.0f, label="Service description", description="The description of this component configuration. It is used to easily identify the service registered by this component.")})
@ManualServices(value={@ManualService(value={Configuration.class})})
@ExtendComponent
public class QuerydslConfigurationComponent {
    private static final int P_NAME_MAPPING = 3;
    public static final int P_SERVICE_DESCRIPTION = 0;
    public static final int P_SQL_TEMPLATES = 1;
    public static final int P_USE_LITERALS = 2;
    private NameMapping nameMapping;
    private ServiceRegistration<Configuration> serviceRegistration;
    private SQLTemplates sqlTemplates;

    @Activate
    public void activate(ComponentContext<QuerydslConfigurationComponent> componentContext) {
        Configuration configuration = new Configuration(this.sqlTemplates);
        Map componentPropeties = componentContext.getProperties();
        Object useLiteralsProp = componentPropeties.get("useLiterals");
        if (useLiteralsProp != null) {
            configuration.setUseLiterals(Boolean.valueOf(useLiteralsProp.toString()).booleanValue());
        }
        if (this.nameMapping != null) {
            configuration.setDynamicNameMapping(this.nameMapping);
        }
        Hashtable serviceProperties = new Hashtable(componentPropeties);
        this.serviceRegistration = componentContext.registerService(Configuration.class, (Object)configuration, serviceProperties);
    }

    @Deactivate
    public void deactivate() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }

    @ServiceRef(attributeId="nameMapping.target", attributePriority=3.0f, optional=true, label="NameMapping OSGi filter", description="OSGi filter for the nameMapping reference that will be used for dynamic name mapping if available.")
    public void setNameMapping(NameMapping nameMapping) {
        this.nameMapping = nameMapping;
    }

    @ServiceRef(attributeId="sqlTemplates.target", defaultValue={""}, attributePriority=1.0f, label="SQLTemplates OSGi filter", description="OSGi filter for the sqlTemplates reference that will be embedded into the configuration.")
    public void setSqlTemplates(SQLTemplates sqlTemplates) {
        this.sqlTemplates = sqlTemplates;
    }
}

