/*
 * Decompiled with CFR 0.152.
 */
package org.everit.persistence.querydsl.ecm.internal;

import com.querydsl.sql.Configuration;
import java.util.Hashtable;
import javax.sql.DataSource;
import org.everit.osgi.ecm.annotation.Activate;
import org.everit.osgi.ecm.annotation.Component;
import org.everit.osgi.ecm.annotation.ConfigurationPolicy;
import org.everit.osgi.ecm.annotation.Deactivate;
import org.everit.osgi.ecm.annotation.ManualService;
import org.everit.osgi.ecm.annotation.ManualServices;
import org.everit.osgi.ecm.annotation.ServiceRef;
import org.everit.osgi.ecm.annotation.attribute.StringAttribute;
import org.everit.osgi.ecm.annotation.attribute.StringAttributes;
import org.everit.osgi.ecm.component.ComponentContext;
import org.everit.osgi.ecm.extender.ExtendComponent;
import org.everit.persistence.querydsl.support.QuerydslSupport;
import org.everit.persistence.querydsl.support.ri.QuerydslSupportImpl;
import org.osgi.framework.ServiceRegistration;

@Component(componentId="org.everit.persistence.querydsl.ecm.QuerydslSupport", configurationPolicy=ConfigurationPolicy.FACTORY, label="Everit Querydsl Support", description="Component that registers a QuerydslSupport OSGi service.")
@StringAttributes(value={@StringAttribute(attributeId="service.description", defaultValue={"Everit Querydsl Support"}, priority=0.0f, label="Service Description", description="The description of this component configuration. It is used to easily identify the service registered by this component.")})
@ManualServices(value={@ManualService(value={QuerydslSupport.class})})
@ExtendComponent
public class QuerydslSupportComponent {
    public static final int P00_SERVICE_DESCRIPTION = 0;
    public static final int P01_DATA_SOURCE = 1;
    public static final int P02_CONFIGURATION = 2;
    private Configuration configuration;
    private DataSource dataSource;
    private ServiceRegistration<QuerydslSupport> serviceRegistration;

    @Activate
    public void activate(ComponentContext<QuerydslSupportComponent> componentContext) {
        QuerydslSupportImpl querydslSupport = new QuerydslSupportImpl(this.configuration, this.dataSource);
        Hashtable serviceProperties = new Hashtable(componentContext.getProperties());
        this.serviceRegistration = componentContext.registerService(QuerydslSupport.class, (Object)querydslSupport, serviceProperties);
    }

    @Deactivate
    public void deactivate() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }

    @ServiceRef(attributeId="configuration.target", defaultValue={""}, attributePriority=2.0f, label="Configuration OSGi filter", description="OSGi filter for Querydsl Configuration service instance.")
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @ServiceRef(attributeId="dataSource.target", defaultValue={""}, attributePriority=1.0f, label="DataSource OSGi filter", description="OSGi filter for javax.sql.DataSource OSGi service")
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

