/*
 * Decompiled with CFR 0.152.
 */
package org.everit.persistence.querydsl.ecm.internal;

import com.querydsl.sql.SQLTemplates;
import java.util.Objects;
import org.everit.osgi.ecm.annotation.Component;
import org.everit.osgi.ecm.annotation.ConfigurationPolicy;
import org.everit.osgi.ecm.annotation.ManualService;
import org.everit.osgi.ecm.annotation.ManualServices;
import org.everit.osgi.ecm.annotation.attribute.StringAttribute;
import org.everit.osgi.ecm.annotation.attribute.StringAttributeOption;
import org.everit.osgi.ecm.extender.ExtendComponent;
import org.everit.persistence.querydsl.ecm.DBMSType;
import org.everit.persistence.querydsl.ecm.UnknownDatabaseTypeException;
import org.everit.persistence.querydsl.ecm.internal.AbstractSQLTemplatesComponent;

@Component(componentId="org.everit.persistence.querydsl.ecm.SQLTemplates", metatype=true, configurationPolicy=ConfigurationPolicy.FACTORY, label="Everit Querydsl SQLTemplates", description="By configuring this component, the user will get an SQLTemplate as an OSGi service.")
@ManualServices(value={@ManualService(value={SQLTemplates.class})})
@ExtendComponent
public class SQLTemplatesComponent
extends AbstractSQLTemplatesComponent {
    public static final int P_DB_TYPE = 1;
    private String dbType;

    @Override
    protected DBMSType getDBMSType() {
        Objects.requireNonNull(this.dbType, "dbType cannot be null");
        for (DBMSType dbmsType : DBMSType.values()) {
            if (!dbmsType.toString().equals(this.dbType)) continue;
            return dbmsType;
        }
        throw new UnknownDatabaseTypeException("database type [" + this.dbType + "] is not supported");
    }

    @StringAttribute(attributeId="dbType", priority=1.0f, label="Database type", description="Type of the SQLTemplate which will be created.", defaultValue={"H2"}, options={@StringAttributeOption(label="H2", value="H2"), @StringAttributeOption(label="Postgres", value="Postgres"), @StringAttributeOption(label="MySQL", value="MySQL"), @StringAttributeOption(label="Oracle", value="Oracle"), @StringAttributeOption(label="SQLite", value="SQLite"), @StringAttributeOption(label="CUBRID", value="CUBRID"), @StringAttributeOption(label="Derby", value="Derby"), @StringAttributeOption(label="HSQLDB", value="HSQLDB"), @StringAttributeOption(label="Teradata", value="Teradata"), @StringAttributeOption(label="SQLServer", value="SQLServer"), @StringAttributeOption(label="SQLServer2005", value="SQLServer2005"), @StringAttributeOption(label="SQLServer2008", value="SQLServer2008"), @StringAttributeOption(label="SQLServer2012", value="SQLServer2012")})
    public void setDbType(String dbtype) {
        this.dbType = dbtype;
    }
}

