/*
 * Decompiled with CFR 0.152.
 */
package org.everit.props.ri.ecm.internal;

import java.util.Hashtable;
import java.util.concurrent.ConcurrentMap;
import org.everit.osgi.ecm.annotation.Activate;
import org.everit.osgi.ecm.annotation.Component;
import org.everit.osgi.ecm.annotation.ConfigurationPolicy;
import org.everit.osgi.ecm.annotation.Deactivate;
import org.everit.osgi.ecm.annotation.ManualService;
import org.everit.osgi.ecm.annotation.ManualServices;
import org.everit.osgi.ecm.annotation.ServiceRef;
import org.everit.osgi.ecm.annotation.attribute.StringAttribute;
import org.everit.osgi.ecm.annotation.attribute.StringAttributes;
import org.everit.osgi.ecm.component.ComponentContext;
import org.everit.osgi.ecm.extender.ExtendComponent;
import org.everit.persistence.querydsl.support.QuerydslSupport;
import org.everit.props.PropertyManager;
import org.everit.props.ri.PropertyManagerImpl;
import org.everit.transaction.propagator.TransactionPropagator;
import org.osgi.framework.ServiceRegistration;

@Component(componentId="org.everit.props.ri.ecm.PropertyManager", configurationPolicy=ConfigurationPolicy.FACTORY, label="Everit Property Manager", description="By configuring this component, the user will get a persistent PropertyManager as an OSGi service.")
@StringAttributes(value={@StringAttribute(attributeId="service.description", defaultValue={"Default Property Manager"}, priority=1.0f, label="Service Description", description="The description of this component configuration. It is used to easily identify the service registered by this component.")})
@ManualServices(value={@ManualService(value={PropertyManager.class})})
@ExtendComponent
public class PropertyComponent {
    public static final int P01_SERVICE_DESCRITION = 1;
    public static final int P02_QUERYDSL_SUPPORT = 2;
    public static final int P03_TRANSACTION_PROPAGATOR = 3;
    public static final int P04_CACHE = 4;
    private ConcurrentMap<String, String> cache;
    private QuerydslSupport querydslSupport;
    private ServiceRegistration<PropertyManager> serviceRegistration;
    private TransactionPropagator transactionPropagator;

    @Activate
    public void activate(ComponentContext<PropertyComponent> componentContext) {
        PropertyManagerImpl propertyManager = new PropertyManagerImpl(this.cache, this.querydslSupport, this.transactionPropagator);
        Hashtable serviceProperties = new Hashtable(componentContext.getProperties());
        this.serviceRegistration = componentContext.registerService(PropertyManager.class, (Object)propertyManager, serviceProperties);
    }

    @Deactivate
    public void deactivate() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }

    @ServiceRef(attributeId="cache.target", defaultValue={"(MUST_BE_SET=TO_SOMETHING)"}, attributePriority=4.0f, label="Cache filter", description="The OSGi filter expression to select the right Cache (java.util.concurrent.ConcurrentMap).")
    public void setCache(ConcurrentMap<String, String> cache) {
        this.cache = cache;
    }

    @ServiceRef(attributeId="querydslSupport.target", defaultValue={""}, attributePriority=2.0f, label="Querydsl Support OSGi filter", description="OSGi Service filter expression for QueryDSLSupport instance.")
    public void setQuerydslSupport(QuerydslSupport querydslSupport) {
        this.querydslSupport = querydslSupport;
    }

    @ServiceRef(attributeId="transactionHelper.target", defaultValue={""}, attributePriority=3.0f, label="Transaction Propagator OSGi filter", description="OSGi Service filter expression for TransactionPropagator instance.")
    public void setTransactionPropagator(TransactionPropagator transactionPropagator) {
        this.transactionPropagator = transactionPropagator;
    }
}

