/*
 * Decompiled with CFR 0.152.
 */
package org.everit.props.ri;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.everit.persistence.querydsl.support.QuerydslSupport;
import org.everit.props.PropertyManager;
import org.everit.props.ri.schema.qdsl.QProperty;
import org.everit.transaction.propagator.TransactionPropagator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyManagerImpl
implements PropertyManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyManagerImpl.class);
    private ConcurrentMap<String, String> cache;
    private QuerydslSupport querydslSupport;
    private TransactionPropagator transactionPropagator;

    public PropertyManagerImpl(ConcurrentMap<String, String> cache, QuerydslSupport querydslSupport, TransactionPropagator transactionPropagator) {
        this.cache = Objects.requireNonNull(cache, "chache cannot be null");
        this.querydslSupport = Objects.requireNonNull(querydslSupport, "querydslSupport cannot be null");
        this.transactionPropagator = Objects.requireNonNull(transactionPropagator, "transactionPropagator cannot be null");
    }

    public void addProperty(String key, String value) {
        Objects.requireNonNull(key, "Null key is not supported!");
        Objects.requireNonNull(value, "Null values are not supported!");
        this.transactionPropagator.required(() -> (Long)this.querydslSupport.execute((connection, configuration) -> {
            QProperty prop = QProperty.property;
            return new SQLInsertClause(connection, configuration, (RelationalPath)prop).set((Path)prop.key, (Object)key).set((Path)prop.value, (Object)value).execute();
        }));
    }

    public String getProperty(String key) {
        Objects.requireNonNull(key, "Null key is not supported!");
        String cachedValue = (String)this.cache.get(key);
        if (cachedValue != null) {
            return cachedValue;
        }
        String value = (String)this.querydslSupport.execute((connection, configuration) -> {
            QProperty prop = QProperty.property;
            return (String)((SQLQuery)((SQLQuery)new SQLQuery(connection, configuration).select((Expression)prop.value).from((Expression)prop)).where((Predicate)prop.key.eq((Object)key))).fetchOne();
        });
        try {
            this.cache.put(key, value);
        }
        catch (NullPointerException e) {
            LOGGER.warn("Cannot cache null value for key [" + key + "], because the cache implementation [" + this.cache.getClass() + "] does not permit null values.");
        }
        return value;
    }

    public String removeProperty(String key) {
        Objects.requireNonNull(key, "Null key is not supported!");
        String previousValue = this.getProperty(key);
        boolean deleted = (Boolean)this.transactionPropagator.required(() -> (Boolean)this.querydslSupport.execute((connection, configuration) -> {
            QProperty prop = QProperty.property;
            long deletedRowNum = new SQLDeleteClause(connection, configuration, (RelationalPath)prop).where((Predicate)prop.key.eq((Object)key)).execute();
            this.cache.remove(key);
            return deletedRowNum > 0L;
        }));
        if (deleted) {
            return previousValue;
        }
        return null;
    }

    public String updateProperty(String key, String newValue) {
        Objects.requireNonNull(key, "Null key is not supported!");
        Objects.requireNonNull(newValue, "Null values are not supported!");
        String previousValue = this.getProperty(key);
        boolean updated = (Boolean)this.transactionPropagator.required(() -> (Boolean)this.querydslSupport.execute((connection, configuration) -> {
            QProperty prop = QProperty.property;
            long updatedRowNum = new SQLUpdateClause(connection, configuration, (RelationalPath)prop).where((Predicate)prop.key.eq((Object)key)).set((Path)prop.value, (Object)newValue).execute();
            this.cache.replace(key, newValue);
            return updatedRowNum > 0L;
        }));
        if (updated) {
            return previousValue;
        }
        return null;
    }
}

