/*
 * Decompiled with CFR 0.152.
 */
package org.everit.resource.ri.ecm.internal;

import aQute.bnd.annotation.headers.ProvideCapability;
import java.util.Hashtable;
import org.everit.osgi.ecm.annotation.Activate;
import org.everit.osgi.ecm.annotation.Component;
import org.everit.osgi.ecm.annotation.ConfigurationPolicy;
import org.everit.osgi.ecm.annotation.Deactivate;
import org.everit.osgi.ecm.annotation.ManualService;
import org.everit.osgi.ecm.annotation.ServiceRef;
import org.everit.osgi.ecm.annotation.attribute.StringAttribute;
import org.everit.osgi.ecm.annotation.attribute.StringAttributes;
import org.everit.osgi.ecm.component.ComponentContext;
import org.everit.persistence.querydsl.support.QuerydslSupport;
import org.everit.resource.ResourceService;
import org.everit.resource.ri.ResourceServiceImpl;
import org.osgi.framework.ServiceRegistration;

@Component(componentId="org.everit.resource.ri.ecm.Resource", configurationPolicy=ConfigurationPolicy.FACTORY, label="Everit Resource RI", description="Resource component manages resource table.")
@StringAttributes(value={@StringAttribute(attributeId="service.description", defaultValue={"Default Resource Service"}, priority=1.0f, label="Service Description", description="The description of this component configuration. It is used to easily identify the service registered by this component.")})
@ManualService(value={ResourceService.class})
@ProvideCapability(ns="org.everit.osgi.ecm.component", value="class=${@class}")
public class ResourceComponent {
    private QuerydslSupport querydslSupport;
    private ServiceRegistration<ResourceService> serviceRegistration;

    @Activate
    public void activate(ComponentContext<ResourceComponent> componentContext) {
        ResourceServiceImpl resourceService = new ResourceServiceImpl(this.querydslSupport);
        Hashtable serviceProperties = new Hashtable(componentContext.getProperties());
        this.serviceRegistration = componentContext.registerService(ResourceService.class, (Object)resourceService, serviceProperties);
    }

    @Deactivate
    public void deactivate() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }

    @ServiceRef(attributeId="querydslSupport.target", defaultValue={""}, attributePriority=2.0f, label="Querydsl Support OSGi filter", description="OSGi Service filter expression for QueryDSLSupport instance.")
    public void setQuerydslSupport(QuerydslSupport querydslSupport) {
        this.querydslSupport = querydslSupport;
    }
}

