/*
 * Decompiled with CFR 0.152.
 */
package org.everit.resource.ri;

import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import java.util.Objects;
import org.everit.persistence.querydsl.support.QuerydslSupport;
import org.everit.resource.ResourceService;
import org.everit.resource.ri.schema.qdsl.QResource;

public class ResourceServiceImpl
implements ResourceService {
    private final QuerydslSupport querydslSupport;

    public ResourceServiceImpl(QuerydslSupport querydslSupport) {
        this.querydslSupport = Objects.requireNonNull(querydslSupport, "QuerydslSupport cannot be null.");
    }

    public long createResource() {
        return (Long)this.querydslSupport.execute((connection, configuration) -> {
            QResource qResource = QResource.resource;
            new SQLInsertClause(connection, configuration, (RelationalPath)qResource);
            return (Long)new SQLInsertClause(connection, configuration, (RelationalPath)qResource).executeWithKey((Path)qResource.resourceId);
        });
    }

    public boolean deleteResource(long resourceId) {
        return (Boolean)this.querydslSupport.execute((connection, configuration) -> {
            QResource qResource = QResource.resource;
            long deletedRecordNum = new SQLDeleteClause(connection, configuration, (RelationalPath)qResource).where((Predicate)qResource.resourceId.eq((Object)resourceId)).execute();
            return deletedRecordNum > 0L;
        });
    }
}

