/*
 * Decompiled with CFR 0.152.
 */
package org.everit.templating.html.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.everit.expression.CompiledExpression;
import org.everit.templating.html.internal.CompiledExpressionHolder;
import org.everit.templating.html.internal.ParentNode;
import org.everit.templating.html.internal.RenderException;
import org.everit.templating.html.internal.RenderScope;
import org.everit.templating.html.internal.RenderableAttribute;
import org.everit.templating.html.internal.TemplateContextImpl;
import org.everit.templating.html.internal.util.HTMLTemplatingUtil;
import org.everit.templating.util.TemplateWriter;
import org.everit.templating.util.UniversalIterable;
import org.htmlparser.Tag;
import org.htmlparser.lexer.Page;
import org.htmlparser.lexer.PageAttribute;

public class TagNode
extends ParentNode {
    private CompiledExpressionHolder attributeAppendMapExpressionHolder;
    private CompiledExpressionHolder attributeMapExpressionHolder;
    private CompiledExpressionHolder attributePrependMapExpressionHolder;
    private CompiledExpressionHolder codeExpressionHolder = null;
    private final boolean emptyTag;
    private String endTag = null;
    private boolean escapeText = false;
    private CompiledExpressionHolder foreachExpressionHolder = null;
    private final Map<String, RenderableAttribute> renderableAttributes = new LinkedHashMap<String, RenderableAttribute>();
    private CompiledExpressionHolder renderExpressionHolder = null;
    private final int startPositionInTemplate;
    private String tagName;
    private CompiledExpressionHolder textExpressionHolder = null;
    private final char[] textRepresentation;
    private CompiledExpressionHolder varExpressionHolder = null;

    public TagNode(Tag tag) {
        this.emptyTag = tag.isEmptyXmlTag();
        Page page = tag.getPage();
        this.startPositionInTemplate = tag.getStartPosition();
        int endPosition = tag.getEndPosition();
        int length = endPosition - this.startPositionInTemplate;
        this.textRepresentation = new char[length];
        page.getText(this.textRepresentation, 0, this.startPositionInTemplate, endPosition);
    }

    private void assignForEachVariables(Map<String, Object> vars, ForeachItem item, int index, Object value) {
        vars.put(item.valueVarName, value);
        if (item.indexVarName != null) {
            vars.put(item.indexVarName, index);
        }
    }

    private void evaluateCode(TemplateContextImpl templateContext) {
        if (this.codeExpressionHolder == null) {
            return;
        }
        this.codeExpressionHolder.compiledExpression.eval(templateContext.getVars());
    }

    private <R> R evaluateExpression(CompiledExpressionHolder expressionHolder, TemplateContextImpl templateContext, Class<R> clazz) {
        if (expressionHolder == null) {
            return null;
        }
        Object result = expressionHolder.compiledExpression.eval(templateContext.getVars());
        if (result == null) {
            return null;
        }
        if (!clazz.isAssignableFrom(result.getClass())) {
            throw new RenderException("The result type " + result.getClass() + " cannot be assigned to the expected type " + clazz.getName(), expressionHolder.attributeInfo);
        }
        Object typedResult = result;
        return (R)typedResult;
    }

    private Map<Object, Object> evaluateForeachMap(TemplateContextImpl templateContext) {
        if (this.foreachExpressionHolder == null) {
            return null;
        }
        Map result = this.evaluateExpression(this.foreachExpressionHolder, templateContext, Map.class);
        return result;
    }

    private RenderScope evaluateRender(TemplateContextImpl templateContext) {
        Object renderValue = this.evaluateExpression(this.renderExpressionHolder, templateContext, Object.class);
        if (renderValue == null) {
            return RenderScope.ALL;
        }
        if (renderValue instanceof Boolean) {
            if (((Boolean)renderValue).booleanValue()) {
                return RenderScope.ALL;
            }
            return RenderScope.NONE;
        }
        if (renderValue instanceof RenderScope) {
            return (RenderScope)((Object)renderValue);
        }
        String renderString = !(renderValue instanceof String) ? String.valueOf(renderValue) : (String)renderValue;
        if (renderString.equalsIgnoreCase(RenderScope.ALL.toString())) {
            return RenderScope.ALL;
        }
        if (renderString.equalsIgnoreCase(RenderScope.NONE.toString())) {
            return RenderScope.NONE;
        }
        if (renderString.equalsIgnoreCase(RenderScope.CONTENT.toString())) {
            return RenderScope.CONTENT;
        }
        if (renderString.equalsIgnoreCase(RenderScope.TAG.toString())) {
            return RenderScope.TAG;
        }
        throw new RenderException("Unrecognized value for render attribute: " + renderString, this.renderExpressionHolder.attributeInfo);
    }

    private Map<String, Object> evaluateTagVariables(TemplateContextImpl templateContext) {
        if (this.varExpressionHolder == null) {
            return null;
        }
        CompiledExpression compiledExpression = this.varExpressionHolder.compiledExpression;
        Object result = compiledExpression.eval(templateContext.getVars());
        if (result == null) {
            return null;
        }
        if (!(result instanceof Map)) {
            throw new RenderException("Unrecognized type at attribute override map: " + result.getClass(), this.varExpressionHolder.attributeInfo);
        }
        Map tagVarMap = (Map)result;
        for (Object key : tagVarMap.keySet()) {
            if (key != null && key instanceof String) continue;
            throw new RenderException("Attribute override Map should have only String keys: " + key, this.varExpressionHolder.attributeInfo);
        }
        Map mapResult = (Map)result;
        return mapResult;
    }

    private String evaluateText(Map<String, Object> vars) {
        if (this.textExpressionHolder == null) {
            return null;
        }
        Object text = this.textExpressionHolder.compiledExpression.eval(vars);
        if (text == null) {
            return "";
        }
        String textString = text.toString();
        if (this.escapeText) {
            textString = HTMLTemplatingUtil.escape(textString);
        }
        return textString;
    }

    public CompiledExpressionHolder getAttributeAppendMapExpressionHolder() {
        return this.attributeAppendMapExpressionHolder;
    }

    public CompiledExpressionHolder getAttributeMapExpressionHolder() {
        return this.attributeMapExpressionHolder;
    }

    public CompiledExpressionHolder getAttributePrependMapExpressionHolder() {
        return this.attributePrependMapExpressionHolder;
    }

    public CompiledExpressionHolder getCodeExpressionHolder() {
        return this.codeExpressionHolder;
    }

    public CompiledExpressionHolder getForeachExpressionHolder() {
        return this.foreachExpressionHolder;
    }

    public Map<String, RenderableAttribute> getRenderableAttributes() {
        return this.renderableAttributes;
    }

    public CompiledExpressionHolder getRenderExpressionHolder() {
        return this.renderExpressionHolder;
    }

    public String getTagName() {
        return this.tagName;
    }

    public CompiledExpressionHolder getTextExpressionHolder() {
        return this.textExpressionHolder;
    }

    public CompiledExpressionHolder getVarExpressionHolder() {
        return this.varExpressionHolder;
    }

    public boolean isEscapeText() {
        return this.escapeText;
    }

    @Override
    public void render(TemplateContextImpl templateContext) {
        Map<Object, Object> foreachMap = this.evaluateForeachMap(templateContext);
        if (this.foreachExpressionHolder != null && (foreachMap == null || foreachMap.size() == 0)) {
            return;
        }
        if (foreachMap != null) {
            this.renderEach(templateContext, foreachMap);
        } else {
            this.renderItem(templateContext);
        }
    }

    private void renderAttribute(TemplateWriter writer, String attributeName, RenderableAttribute renderableAttribute, TagAttributeRenderContext actx) {
        String appendText;
        String attributeValue = renderableAttribute.getConstantValue();
        if (actx.valueMap != null && actx.valueMap.containsKey(attributeName)) {
            Object attributeValueObject = actx.valueMap.remove(attributeName);
            attributeValue = attributeValueObject != null ? attributeValueObject.toString() : null;
        } else {
            CompiledExpressionHolder expressionHolder = renderableAttribute.getExpressionHolder();
            if (expressionHolder != null) {
                Object attributeValueObject = this.evaluateExpression(expressionHolder, actx.templateContext, Object.class);
                attributeValue = attributeValueObject != null ? attributeValueObject.toString() : null;
            }
        }
        String prependText = this.resolveXPend(attributeName, actx.prependValueMap, renderableAttribute.getPrependExpressionHolder(), actx.templateContext);
        if (prependText != null) {
            attributeValue = prependText + (attributeValue != null ? attributeValue : "");
        }
        if ((appendText = this.resolveXPend(attributeName, actx.appendValueMap, renderableAttribute.getAppendExpressionHolder(), actx.templateContext)) != null) {
            attributeValue = (attributeValue != null ? attributeValue : "") + appendText;
        }
        if (attributeValue != null) {
            String previousText = renderableAttribute.getPreviousText();
            if (previousText != null) {
                writer.append(previousText);
            }
            writer.append(attributeName);
            PageAttribute pageAttribute = renderableAttribute.getPageAttribute();
            if (pageAttribute == null) {
                pageAttribute = renderableAttribute.getExpressionPageAttribute();
                if (pageAttribute == null) {
                    pageAttribute = renderableAttribute.getPrependPageAttribute();
                }
                if (pageAttribute == null) {
                    pageAttribute = renderableAttribute.getAppendPageAttribute();
                }
            }
            String assigment = "=";
            char quote = '\"';
            if (pageAttribute != null) {
                assigment = pageAttribute.getAssignment();
                quote = pageAttribute.getQuote();
            }
            String quoteString = String.valueOf(quote);
            writer.append(assigment).append(quoteString).append(HTMLTemplatingUtil.escape(attributeValue)).append(quoteString);
        }
    }

    private void renderContent(TemplateContextImpl templateContext) {
        RenderScope render = this.evaluateRender(templateContext);
        if (render == RenderScope.NONE) {
            return;
        }
        String text = null;
        if (render == RenderScope.ALL || render == RenderScope.CONTENT) {
            text = this.evaluateText(templateContext.getVars());
        }
        if (render == RenderScope.ALL || render == RenderScope.TAG) {
            this.renderTag(templateContext, text, render == RenderScope.ALL);
        } else if (text != null) {
            templateContext.getWriter().append(text);
        } else {
            this.renderChildren(templateContext);
        }
    }

    private void renderEach(TemplateContextImpl templateContext, Map<Object, Object> foreachMap) {
        Set<Map.Entry<Object, Object>> entrySet = foreachMap.entrySet();
        ForeachItem[] items = new ForeachItem[foreachMap.size()];
        int i = 0;
        for (Map.Entry<Object, Object> entry : entrySet) {
            Object key = entry.getKey();
            if (key == null) {
                throw new RenderException("Null key in the foreach map: " + foreachMap.toString(), this.foreachExpressionHolder.attributeInfo);
            }
            Object value = entry.getValue();
            if (value == null) {
                return;
            }
            if (!value.getClass().isArray() && !(value instanceof Iterable)) {
                throw new RenderException("Unrecognized value type in foreach map: " + value.getClass(), this.foreachExpressionHolder.attributeInfo);
            }
            String valueVarName = null;
            String indexVarName = null;
            if (key instanceof String) {
                valueVarName = (String)key;
            } else if (key instanceof Object[]) {
                Object[] foreachKeyObjArray = (Object[])key;
                if (foreachKeyObjArray.length == 0 || foreachKeyObjArray.length > 2) {
                    throw new RenderException("Foreach key should contain one or two elements: " + Arrays.toString(foreachKeyObjArray), this.foreachExpressionHolder.attributeInfo);
                }
                valueVarName = String.valueOf(foreachKeyObjArray[0]);
                if (foreachKeyObjArray.length == 2) {
                    indexVarName = String.valueOf(foreachKeyObjArray[1]);
                }
            } else {
                throw new RenderException("Unrecognized type for foreach key: " + key.getClass(), this.foreachExpressionHolder.attributeInfo);
            }
            ForeachItem item = new ForeachItem();
            item.collection = value;
            item.indexVarName = indexVarName;
            item.valueVarName = valueVarName;
            items[i] = item;
            ++i;
        }
        this.renderEachRecurse(templateContext, items, 0);
    }

    private void renderEachRecurse(TemplateContextImpl templateContext, ForeachItem[] items, int mapEntryIndex) {
        if (mapEntryIndex == items.length) {
            this.renderItem(templateContext);
        } else {
            ForeachItem item = items[mapEntryIndex];
            Object collectionObject = item.collection;
            Map vars = templateContext.getVars();
            UniversalIterable iterable = new UniversalIterable(collectionObject);
            Iterator iterator = iterable.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                Object value = iterator.next();
                this.assignForEachVariables(vars, item, i, value);
                this.renderEachRecurse(templateContext, items, mapEntryIndex + 1);
                ++i;
            }
        }
    }

    private void renderItem(TemplateContextImpl templateContext) {
        this.evaluateCode(templateContext);
        Map<String, Object> tagVars = this.evaluateTagVariables(templateContext);
        if (tagVars != null && tagVars.size() > 0) {
            templateContext.getVars().putAll(tagVars);
            this.renderContent(templateContext);
        } else {
            this.renderContent(templateContext);
        }
    }

    private void renderRemainingAttribute(TemplateContextImpl templateContext, String attributeName, Object prepend, Object attributeValue, Object append) {
        TemplateWriter writer = templateContext.getWriter();
        if (attributeName == null || prepend == null && attributeValue == null && append == null) {
            return;
        }
        writer.append(" ").append(attributeName).append("=\"");
        StringBuilder attributeValueSB = new StringBuilder();
        if (prepend != null) {
            attributeValueSB.append(prepend);
        }
        if (attributeValue != null) {
            attributeValueSB.append(attributeValue);
        }
        if (append != null) {
            attributeValueSB.append(append);
        }
        writer.append(HTMLTemplatingUtil.escape(attributeValueSB.toString()));
        writer.append("\"");
    }

    private void renderRemainingAttributesFromMaps(TemplateContextImpl templateContext, TagAttributeRenderContext attributeCtx) {
        String attributeName;
        Map.Entry<String, Object> entry;
        Map<String, Object> valueMap = attributeCtx.valueMap;
        Map<String, Object> prependMap = attributeCtx.prependValueMap;
        Map<String, Object> appendMap = attributeCtx.appendValueMap;
        Iterator<Map.Entry<String, Object>> iterator = valueMap.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            iterator.remove();
            attributeName = entry.getKey();
            Object attributeValue = entry.getValue();
            this.renderRemainingAttribute(templateContext, attributeName, prependMap.remove(attributeName), attributeValue, appendMap.remove(attributeName));
        }
        iterator = prependMap.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            iterator.remove();
            attributeName = entry.getKey();
            Object prepend = entry.getValue();
            this.renderRemainingAttribute(templateContext, attributeName, prepend, null, appendMap.remove(attributeName));
        }
        iterator = appendMap.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            iterator.remove();
            attributeName = entry.getKey();
            Object append = entry.getValue();
            this.renderRemainingAttribute(templateContext, attributeName, null, null, append);
        }
    }

    private void renderTag(TemplateContextImpl templateContext, String text, boolean renderBody) {
        TemplateWriter writer = templateContext.getWriter();
        writer.append("<").append(this.tagName);
        TagAttributeRenderContext attributeCtx = new TagAttributeRenderContext(templateContext);
        for (Map.Entry<String, RenderableAttribute> entry : this.renderableAttributes.entrySet()) {
            String attributeName = entry.getKey();
            RenderableAttribute renderableAttribute = entry.getValue();
            this.renderAttribute(templateContext.getWriter(), attributeName, renderableAttribute, attributeCtx);
        }
        this.renderRemainingAttributesFromMaps(templateContext, attributeCtx);
        if (!renderBody || text == null && this.getChildren().size() == 0) {
            if (this.endTag != null) {
                writer.append(">").append(this.endTag);
            } else {
                if (this.emptyTag) {
                    writer.append(" /");
                }
                writer.append(">");
            }
        } else {
            writer.append(">");
            if (text != null) {
                writer.append(text);
            } else {
                this.renderChildren(templateContext);
            }
            if (this.emptyTag) {
                writer.append("</").append(this.tagName).append(">");
            } else if (this.endTag != null) {
                writer.append(this.endTag);
            }
        }
    }

    private String resolveXPend(String attributeName, Map<String, Object> xpendValueMap, CompiledExpressionHolder xpendExpressionHolder, TemplateContextImpl templateContext) {
        String xpend = null;
        if (xpendValueMap != null && xpendValueMap.containsKey(attributeName)) {
            Object xpendObject = xpendValueMap.remove(attributeName);
            xpend = xpendObject != null ? xpendObject.toString() : null;
        } else if (xpendExpressionHolder != null) {
            Object xpendObject = this.evaluateExpression(xpendExpressionHolder, templateContext, Object.class);
            xpend = xpendObject != null ? xpendObject.toString() : null;
        }
        return xpend;
    }

    public void setAttributeAppendMapExpressionHolder(CompiledExpressionHolder attributeAppendMapExpression) {
        this.attributeAppendMapExpressionHolder = attributeAppendMapExpression;
    }

    public void setAttributeMapExpressionHolder(CompiledExpressionHolder attributeMapExpression) {
        this.attributeMapExpressionHolder = attributeMapExpression;
    }

    public void setAttributePrependMapExpressionHolder(CompiledExpressionHolder attributePrependMapExpression) {
        this.attributePrependMapExpressionHolder = attributePrependMapExpression;
    }

    public void setCodeExpressionHolder(CompiledExpressionHolder codeExpressionHolder) {
        this.codeExpressionHolder = codeExpressionHolder;
    }

    public void setEndTag(String endTag) {
        this.endTag = endTag;
    }

    public void setEscapeText(boolean unescapeText) {
        this.escapeText = unescapeText;
    }

    public void setForeachExpressionHolder(CompiledExpressionHolder foreachExpressionHolder) {
        this.foreachExpressionHolder = foreachExpressionHolder;
    }

    public void setRenderExpressionHolder(CompiledExpressionHolder renderExpressionHolder) {
        this.renderExpressionHolder = renderExpressionHolder;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public void setTextExpressionHolder(CompiledExpressionHolder textExpressionHolder) {
        this.textExpressionHolder = textExpressionHolder;
    }

    public void setVarExpressionHolder(CompiledExpressionHolder varExpressionHolder) {
        this.varExpressionHolder = varExpressionHolder;
    }

    private class TagAttributeRenderContext {
        public final Map<String, Object> appendValueMap;
        public final Map<String, Object> prependValueMap;
        public final TemplateContextImpl templateContext;
        public final Map<String, Object> valueMap;

        public TagAttributeRenderContext(TemplateContextImpl templateContext) {
            Map lam = (Map)TagNode.this.evaluateExpression(TagNode.this.attributeMapExpressionHolder, templateContext, Map.class);
            this.valueMap = this.createWrapperMap(lam);
            Map lapm = (Map)TagNode.this.evaluateExpression(TagNode.this.attributePrependMapExpressionHolder, templateContext, Map.class);
            this.prependValueMap = this.createWrapperMap(lapm);
            Map laam = (Map)TagNode.this.evaluateExpression(TagNode.this.attributeAppendMapExpressionHolder, templateContext, Map.class);
            this.appendValueMap = this.createWrapperMap(laam);
            this.templateContext = templateContext;
        }

        private Map<String, Object> createWrapperMap(Map<String, Object> wrapped) {
            if (wrapped == null) {
                return new HashMap<String, Object>();
            }
            return new HashMap<String, Object>(wrapped);
        }
    }

    private class ForeachItem {
        public Object collection;
        public String indexVarName;
        public String valueVarName;

        private ForeachItem() {
        }
    }
}

