/*
 * Decompiled with CFR 0.152.
 */
package org.everit.templating.html.internal.util;

import org.everit.templating.html.internal.util.Coordinate;
import org.everit.templating.util.CompileException;
import org.htmlparser.Tag;
import org.htmlparser.lexer.Page;
import org.htmlparser.lexer.PageAttribute;

public class HTMLTemplatingUtil {
    public static boolean attributeConstantEquals(String expectedAttributeValue, String currentAttributeValue) {
        if (currentAttributeValue == null) {
            return false;
        }
        if (!((currentAttributeValue = currentAttributeValue.trim()).startsWith("\"") && currentAttributeValue.endsWith("\"") || currentAttributeValue.startsWith("'") && currentAttributeValue.endsWith("'"))) {
            return false;
        }
        currentAttributeValue = currentAttributeValue.substring(1, currentAttributeValue.length() - 1);
        return currentAttributeValue.equalsIgnoreCase(expectedAttributeValue);
    }

    public static Coordinate calculateCoordinate(Page page, int cursor, Coordinate coordinateOffset) {
        int row = page.row(cursor);
        int column = page.column(cursor) + (row == 0 ? coordinateOffset.column : 1);
        return new Coordinate(row += coordinateOffset.row, column);
    }

    public static String escape(String textString) {
        StringBuilder sb = new StringBuilder(textString.length());
        int n = textString.length();
        block7: for (int i = 0; i < n; ++i) {
            char charAt = textString.charAt(i);
            switch (charAt) {
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                default: {
                    sb.append(charAt);
                }
            }
        }
        return sb.toString();
    }

    public static String repeatChar(char c, int times) {
        char[] n = new char[times];
        for (int i = 0; i < times; ++i) {
            n[i] = c;
        }
        return new String(n);
    }

    public static void throwCompileExceptionForAttribute(String message, Tag tag, PageAttribute attribute, boolean positionOfAttributeValue, Coordinate startPosition) {
        Page page = tag.getPage();
        int tagStartPosition = tag.getStartPosition();
        int tagEndPosition = tag.getEndPosition();
        char[] expr = new char[tagEndPosition - tagStartPosition];
        page.getText(expr, 0, tagStartPosition, tagEndPosition);
        int positionInPage = tagStartPosition + 1;
        int cursor = 1;
        if (attribute != null) {
            positionInPage = positionOfAttributeValue ? attribute.getValueStartPosition() : attribute.getNameStartPosition();
            cursor = positionInPage - tagStartPosition;
        }
        CompileException e = new CompileException(message, expr, cursor);
        Coordinate position = HTMLTemplatingUtil.calculateCoordinate(page, positionInPage, startPosition);
        e.setColumn(position.column);
        e.setLineNumber(position.row);
        throw e;
    }

    public static String unescape(String text) {
        StringBuilder result = new StringBuilder(text.length());
        int i = 0;
        int n = text.length();
        while (i < n) {
            char charAt = text.charAt(i);
            if (charAt != '&') {
                result.append(charAt);
                ++i;
                continue;
            }
            if (text.startsWith("&amp;", i)) {
                result.append('&');
                i += 5;
                continue;
            }
            if (text.startsWith("&apos;", i)) {
                result.append('\'');
                i += 6;
                continue;
            }
            if (text.startsWith("&quot;", i)) {
                result.append('\"');
                i += 6;
                continue;
            }
            if (text.startsWith("&lt;", i)) {
                result.append('<');
                i += 4;
                continue;
            }
            if (text.startsWith("&gt;", i)) {
                result.append('>');
                i += 4;
                continue;
            }
            result.append(charAt);
            ++i;
        }
        return result.toString();
    }
}

