/*
 * Decompiled with CFR 0.152.
 */
package org.everit.templating.html;

import java.util.HashMap;
import java.util.Map;
import org.everit.expression.ExpressionCompiler;
import org.everit.expression.ParserConfiguration;
import org.everit.templating.CompiledTemplate;
import org.everit.templating.TemplateCompiler;
import org.everit.templating.html.internal.CompiledTemplateImpl;
import org.everit.templating.html.internal.HTMLNodeVisitor;
import org.htmlparser.Node;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.lexer.Page;
import org.htmlparser.lexer.Source;
import org.htmlparser.lexer.StringSource;
import org.htmlparser.util.ParserException;
import org.htmlparser.visitors.NodeVisitor;

public class HTMLTemplateCompiler
implements TemplateCompiler {
    public static final String DEFAULT_ATTRIBUTE_PREFIX = "data-eht-";
    private final String ehtAttributeprefix;
    private final ExpressionCompiler expressionCompiler;
    private final Map<String, TemplateCompiler> inlineCompilers;

    public HTMLTemplateCompiler(ExpressionCompiler expressionCompiler) {
        this(DEFAULT_ATTRIBUTE_PREFIX, expressionCompiler, new HashMap<String, TemplateCompiler>());
    }

    public HTMLTemplateCompiler(ExpressionCompiler expressionCompiler, Map<String, TemplateCompiler> inlineCompilers) {
        this(DEFAULT_ATTRIBUTE_PREFIX, expressionCompiler, inlineCompilers);
    }

    public HTMLTemplateCompiler(String ehtAttributeprefix, ExpressionCompiler expressionCompiler, Map<String, TemplateCompiler> inlineCompilers) {
        this.ehtAttributeprefix = ehtAttributeprefix;
        this.expressionCompiler = expressionCompiler;
        this.inlineCompilers = new HashMap<String, TemplateCompiler>(inlineCompilers);
    }

    public CompiledTemplate compile(char[] document, int templateStart, int templateLength, ParserConfiguration parserConfiguration) {
        return this.compile(String.valueOf(document, templateStart, templateLength), parserConfiguration);
    }

    public CompiledTemplate compile(String template, ParserConfiguration parserConfiguration) {
        StringSource source = new StringSource(template);
        Page page = new Page((Source)source);
        Lexer lexer = new Lexer(page);
        HTMLNodeVisitor visitor = new HTMLNodeVisitor(this.ehtAttributeprefix, this.expressionCompiler, this.inlineCompilers, parserConfiguration);
        visitor.beginParsing();
        try {
            Node node = lexer.nextNode();
            while (node != null) {
                node.accept((NodeVisitor)visitor);
                node = lexer.nextNode();
            }
        }
        catch (ParserException e) {
            throw new RuntimeException(e);
        }
        visitor.finishedParsing();
        return new CompiledTemplateImpl(visitor.getRootNode());
    }
}

