/*
 * Decompiled with CFR 0.152.
 */
package org.everit.templating.html.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import org.everit.expression.CompiledExpression;
import org.everit.expression.ExpressionCompiler;
import org.everit.expression.ParserConfiguration;
import org.everit.templating.CompiledTemplate;
import org.everit.templating.TemplateCompiler;
import org.everit.templating.html.internal.AttributeInfo;
import org.everit.templating.html.internal.CompiledExpressionHolder;
import org.everit.templating.html.internal.HTMLNode;
import org.everit.templating.html.internal.InlineNode;
import org.everit.templating.html.internal.ParentNode;
import org.everit.templating.html.internal.RenderableAttribute;
import org.everit.templating.html.internal.RootNode;
import org.everit.templating.html.internal.TagInfo;
import org.everit.templating.html.internal.TagNode;
import org.everit.templating.html.internal.TextNode;
import org.everit.templating.html.internal.UncheckedParserException;
import org.everit.templating.html.internal.util.Coordinate;
import org.everit.templating.html.internal.util.HTMLTemplatingUtil;
import org.htmlparser.Attribute;
import org.htmlparser.Node;
import org.htmlparser.Remark;
import org.htmlparser.Tag;
import org.htmlparser.Text;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.lexer.Page;
import org.htmlparser.lexer.PageAttribute;
import org.htmlparser.util.ParserException;
import org.htmlparser.visitors.NodeVisitor;

public class HTMLNodeVisitor
extends NodeVisitor {
    private StringBuilder currentSB = new StringBuilder();
    private final String ehtAttributePrefix;
    private final ExpressionCompiler expressionCompiler;
    private final Map<String, TemplateCompiler> inlineCompilers;
    private InlineContext inlineContext = null;
    private ParentNode parentNode;
    private final ParserConfiguration parserConfiguration;
    private final RootNode rootNode;
    private int specialVisitDepth = 0;
    private Coordinate startPosition;
    private VisitMode visitMode = VisitMode.NORMAL;
    private LinkedList<VisitorPathElement> visitorPath = new LinkedList();

    public HTMLNodeVisitor(String ewtAttributePrefix, ExpressionCompiler expressionCompiler, Map<String, TemplateCompiler> inlineCompilers, ParserConfiguration parserConfiguration) {
        this.ehtAttributePrefix = ewtAttributePrefix;
        this.inlineCompilers = inlineCompilers;
        this.parserConfiguration = parserConfiguration;
        this.rootNode = new RootNode();
        this.parentNode = this.rootNode;
        this.expressionCompiler = expressionCompiler;
        this.visitorPath.add(new VisitorPathElement().withEwtNode(this.rootNode));
        this.startPosition = new Coordinate(parserConfiguration.getStartRow(), parserConfiguration.getStartColumn());
    }

    private void appendCurrentSBAndClear() {
        if (this.currentSB.length() > 0) {
            this.parentNode.getChildren().add(new TextNode(this.currentSB.toString()));
            this.currentSB = new StringBuilder();
        }
    }

    private CompiledExpressionHolder compileExpression(PageAttribute attribute, TagInfo tagInfo) {
        String attributeValue = attribute.getValue();
        attributeValue = HTMLTemplatingUtil.unescape(attributeValue);
        ParserConfiguration currentParserConfig = new ParserConfiguration(this.parserConfiguration);
        Coordinate position = HTMLTemplatingUtil.calculateCoordinate(attribute.getPage(), attribute.getValueStartPosition(), this.startPosition);
        currentParserConfig.setStartColumn(position.column);
        currentParserConfig.setStartRow(position.row);
        return new CompiledExpressionHolder(this.expressionCompiler.compile(attributeValue, currentParserConfig), new AttributeInfo(attribute, tagInfo, this.startPosition));
    }

    private boolean fakeTag(Tag tag) {
        int endPosition = tag.getEndPosition();
        return !">".equals(tag.getPage().getText(endPosition - 1, endPosition));
    }

    private void fillEhtTagNodeWithAttribute(Tag tag, TagNode tagNode, PageAttribute attribute, String textBeforeAttribute) {
        String attributeName = attribute.getName();
        if (attributeName.startsWith(this.ehtAttributePrefix)) {
            this.processEhtAttribute(tag, tagNode, attribute, textBeforeAttribute, attributeName);
        } else {
            RenderableAttribute renderableAttribute = this.getOrCreateRenderableAttribute(attributeName, tagNode);
            renderableAttribute.setPageAttribute(attribute);
            renderableAttribute.setPreviousText(textBeforeAttribute);
            if (renderableAttribute.getConstantValue() != null) {
                HTMLTemplatingUtil.throwCompileExceptionForAttribute("Duplicate attribute: " + attribute.getName(), tag, attribute, false, this.startPosition);
            }
            renderableAttribute.setConstantValue(attribute.getValue());
        }
    }

    private VisitorPathElement findBeginningPathElementForEndTag(String tagName, ListIterator<VisitorPathElement> iterator) {
        VisitorPathElement beginTagPathElement = null;
        while (beginTagPathElement == null && iterator.hasPrevious()) {
            VisitorPathElement visitorPathElement = iterator.previous();
            if (visitorPathElement.tag == null || !visitorPathElement.tag.getTagName().equals(tagName)) continue;
            beginTagPathElement = visitorPathElement;
            iterator.remove();
            while (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
        }
        return beginTagPathElement;
    }

    private void findParentNodeOnIteratorAndSet(ListIterator<VisitorPathElement> iterator) {
        boolean parentFound = false;
        while (!parentFound && iterator.hasPrevious()) {
            VisitorPathElement visitorPathElement = iterator.previous();
            if (visitorPathElement.ewtNode == null) continue;
            parentFound = true;
            this.parentNode = visitorPathElement.ewtNode;
        }
    }

    public void finishedParsing() {
        this.appendCurrentSBAndClear();
    }

    private RenderableAttribute getOrCreateRenderableAttribute(String attrName, TagNode tagNode) {
        Map<String, RenderableAttribute> renderableAttributes = tagNode.getRenderableAttributes();
        RenderableAttribute renderableAttribute = renderableAttributes.get(attrName);
        if (renderableAttribute == null) {
            renderableAttribute = new RenderableAttribute();
            renderableAttributes.put(attrName, renderableAttribute);
        }
        return renderableAttribute;
    }

    public RootNode getRootNode() {
        return this.rootNode;
    }

    private void handleEWTNode(Tag tag, Vector<PageAttribute> attributes) {
        this.appendCurrentSBAndClear();
        TagNode tagNode = new TagNode(tag);
        tagNode.setTagName(tag.getRawTagName());
        Iterator<PageAttribute> iterator = attributes.iterator();
        iterator.next();
        StringBuffer previousString = new StringBuffer();
        while (iterator.hasNext()) {
            PageAttribute attribute = iterator.next();
            if (attribute.getName() == null || attribute.getAssignment() == null || attribute.getValue() == null) {
                attribute.toString(previousString);
                continue;
            }
            this.fillEhtTagNodeWithAttribute(tag, tagNode, attribute, previousString.toString());
            previousString = new StringBuffer();
        }
        TemplateCompiler inlineCompiler = this.resolveInlineCompiler(tag);
        if (inlineCompiler != null && tagNode.getTextExpressionHolder() != null) {
            HTMLTemplatingUtil.throwCompileExceptionForAttribute("Inline and text cannot be used together within the same tag", tag, null, false, this.startPosition);
        }
        this.parentNode.getChildren().add(tagNode);
        if (!tag.isEmptyXmlTag()) {
            this.visitorPath.add(new VisitorPathElement().withEwtNode(tagNode).withTag(tag));
            this.parentNode = tagNode;
            if (inlineCompiler != null) {
                this.visitMode = VisitMode.INLINE;
                int tagEndPosition = tag.getEndPosition() + 1;
                Page page = tag.getPage();
                int pageRow = page.row(tagEndPosition);
                int column = page.column(tagEndPosition) + (pageRow == 0 ? this.startPosition.column : 1) - 1;
                int row = this.startPosition.row + pageRow;
                this.inlineContext = new InlineContext(inlineCompiler, new Coordinate(row, column));
                this.specialVisitDepth = this.visitorPath.size();
            }
        }
    }

    private void handleFakeTag(Tag tag) {
        if (this.visitMode != VisitMode.NONE) {
            this.currentSB.append(tag.getPage().getText(tag.getStartPosition(), tag.getEndPosition()));
        }
    }

    private void handleNonEWTNode(Tag tag) {
        if (!tag.isEmptyXmlTag()) {
            this.visitorPath.add(new VisitorPathElement().withTag(tag));
        }
        this.currentSB.append(tag.toTagHtml());
    }

    private boolean handleRenderNoneTag(Tag tag) {
        boolean renderNoneTag = false;
        if (this.renderNone(tag)) {
            if (!tag.isEmptyXmlTag()) {
                this.visitorPath.add(new VisitorPathElement().withTag(tag));
                this.visitMode = VisitMode.NONE;
                this.specialVisitDepth = this.visitorPath.size();
            }
            renderNoneTag = true;
        }
        return renderNoneTag;
    }

    private boolean handleTageInNoneAndInlineMode(Tag tag) {
        boolean noneOrInlineTag = false;
        if (this.visitMode == VisitMode.NONE || this.visitMode == VisitMode.INLINE) {
            if (!tag.isEmptyXmlTag()) {
                this.visitorPath.add(new VisitorPathElement().withTag(tag));
            }
            if (this.visitMode == VisitMode.INLINE) {
                this.currentSB.append(tag.toHtml(true));
            }
            noneOrInlineTag = true;
        }
        return noneOrInlineTag;
    }

    private boolean isEwtNode(Vector<PageAttribute> attributes) {
        for (PageAttribute pageAttribute : attributes) {
            String attributeName = pageAttribute.getName();
            if (attributeName == null || !attributeName.startsWith(this.ehtAttributePrefix)) continue;
            return true;
        }
        return false;
    }

    private void processAttrAppendPrefixedAttribute(Tag tag, TagNode tagNode, PageAttribute attribute, String textBeforeAttribute, TagInfo tagInfo, String ewtAttributeName) {
        String attrName = ewtAttributeName.substring("attrappend-".length());
        RenderableAttribute renderableAttribute = this.getOrCreateRenderableAttribute(attrName, tagNode);
        this.throwIfAttributeAlreadyDefined(attribute, renderableAttribute.getAppendExpressionHolder(), tag);
        renderableAttribute.setAppendExpressionHolder(this.compileExpression(attribute, tagInfo));
        renderableAttribute.setAppendPageAttribute(attribute);
        if (renderableAttribute.getPreviousText() == null) {
            renderableAttribute.setPreviousText(textBeforeAttribute);
        }
    }

    private void processAttrPrefixedAttribute(Tag tag, TagNode tagNode, PageAttribute attribute, String textBeforeAttribute, TagInfo tagInfo, String ewtAttributeName) {
        String attrName = ewtAttributeName.substring("attr-".length());
        RenderableAttribute renderableAttribute = this.getOrCreateRenderableAttribute(attrName, tagNode);
        this.throwIfAttributeAlreadyDefined(attribute, renderableAttribute.getExpressionHolder(), tag);
        renderableAttribute.setExpressionHolder(this.compileExpression(attribute, tagInfo));
        renderableAttribute.setExpressionPageAttribute(attribute);
        if (renderableAttribute.getConstantValue() == null) {
            renderableAttribute.setPreviousText(textBeforeAttribute);
        }
    }

    private void processAttrPrependPrefixedAttribute(Tag tag, TagNode tagNode, PageAttribute attribute, String textBeforeAttribute, TagInfo tagInfo, String ewtAttributeName) {
        String attrName = ewtAttributeName.substring("attrprepend-".length());
        RenderableAttribute renderableAttribute = this.getOrCreateRenderableAttribute(attrName, tagNode);
        this.throwIfAttributeAlreadyDefined(attribute, renderableAttribute.getPrependExpressionHolder(), tag);
        renderableAttribute.setPrependExpressionHolder(this.compileExpression(attribute, tagInfo));
        renderableAttribute.setPrependPageAttribute(attribute);
        if (renderableAttribute.getExpressionHolder() == null && renderableAttribute.getConstantValue() == null) {
            renderableAttribute.setPreviousText(textBeforeAttribute);
        }
    }

    private void processEhtAttribute(Tag tag, TagNode tagNode, PageAttribute attribute, String textBeforeAttribute, String attributeName) {
        TagInfo tagInfo = new TagInfo(tag);
        String ehtAttributeName = attributeName.substring(this.ehtAttributePrefix.length());
        if ("fragment".equals(ehtAttributeName)) {
            this.processFragmentAttribute(tag, tagNode, attribute, tagInfo);
        } else if ("foreach".equals(ehtAttributeName)) {
            this.throwIfAttributeAlreadyDefined(attribute, tagNode.getForeachExpressionHolder(), tag);
            tagNode.setForeachExpressionHolder(this.compileExpression(attribute, tagInfo));
        } else if ("code".equals(ehtAttributeName)) {
            this.throwIfAttributeAlreadyDefined(attribute, tagNode.getVarExpressionHolder(), tag);
            tagNode.setCodeExpressionHolder(this.compileExpression(attribute, tagInfo));
        } else if ("var".equals(ehtAttributeName)) {
            this.throwIfAttributeAlreadyDefined(attribute, tagNode.getVarExpressionHolder(), tag);
            tagNode.setVarExpressionHolder(this.compileExpression(attribute, tagInfo));
        } else if ("render".equals(ehtAttributeName)) {
            this.throwIfAttributeAlreadyDefined(attribute, tagNode.getRenderExpressionHolder(), tag);
            tagNode.setRenderExpressionHolder(this.compileExpression(attribute, tagInfo));
        } else if ("text".equals(ehtAttributeName)) {
            this.throwIfAttributeAlreadyDefined(attribute, tagNode.getTextExpressionHolder(), tag);
            tagNode.setTextExpressionHolder(this.compileExpression(attribute, tagInfo));
            tagNode.setEscapeText(true);
        } else if ("utext".equals(ehtAttributeName)) {
            this.throwIfAttributeAlreadyDefined(attribute, tagNode.getTextExpressionHolder(), tag);
            tagNode.setTextExpressionHolder(this.compileExpression(attribute, tagInfo));
            tagNode.setEscapeText(false);
        } else if ("attr".equals(ehtAttributeName)) {
            this.throwIfAttributeAlreadyDefined(attribute, tagNode.getAttributeMapExpressionHolder(), tag);
            tagNode.setAttributeMapExpressionHolder(this.compileExpression(attribute, tagInfo));
        } else if ("attrprepend".equals(ehtAttributeName)) {
            this.throwIfAttributeAlreadyDefined(attribute, tagNode.getAttributePrependMapExpressionHolder(), tag);
            tagNode.setAttributePrependMapExpressionHolder(this.compileExpression(attribute, tagInfo));
        } else if ("attrappend".equals(ehtAttributeName)) {
            this.throwIfAttributeAlreadyDefined(attribute, tagNode.getAttributeAppendMapExpressionHolder(), tag);
            tagNode.setAttributeAppendMapExpressionHolder(this.compileExpression(attribute, tagInfo));
        } else if (ehtAttributeName.startsWith("attr-")) {
            this.processAttrPrefixedAttribute(tag, tagNode, attribute, textBeforeAttribute, tagInfo, ehtAttributeName);
        } else if (ehtAttributeName.startsWith("attrprepend-")) {
            this.processAttrPrependPrefixedAttribute(tag, tagNode, attribute, textBeforeAttribute, tagInfo, ehtAttributeName);
        } else if (ehtAttributeName.startsWith("attrappend-")) {
            this.processAttrAppendPrefixedAttribute(tag, tagNode, attribute, textBeforeAttribute, tagInfo, ehtAttributeName);
        } else if (!"inline".equals(ehtAttributeName)) {
            HTMLTemplatingUtil.throwCompileExceptionForAttribute("Unrecognized attribute name: " + attribute.getName(), tag, attribute, false, this.startPosition);
        }
    }

    private void processFragmentAttribute(Tag tag, TagNode tagNode, PageAttribute attribute, TagInfo tagInfo) {
        CompiledExpressionHolder compileExpression = this.compileExpression(attribute, tagInfo);
        Object fragmentNameObj = compileExpression.compiledExpression.eval(new HashMap());
        if (fragmentNameObj == null) {
            HTMLTemplatingUtil.throwCompileExceptionForAttribute("Null value defined as fragmentId", tag, attribute, false, this.startPosition);
        }
        this.rootNode.addFragment(String.valueOf(fragmentNameObj), tagNode, attribute, this.startPosition, tag);
    }

    private boolean renderNone(Tag tag) {
        String renderAttributeName = this.ehtAttributePrefix + "render";
        String renderValue = tag.getAttribute(renderAttributeName);
        if (renderValue == null) {
            return false;
        }
        return HTMLTemplatingUtil.attributeConstantEquals("none", renderValue.trim()) || "false".equalsIgnoreCase(renderValue.trim());
    }

    private TemplateCompiler resolveInlineCompiler(Tag tag) {
        String inlineAttributeName = this.ehtAttributePrefix + "inline";
        Attribute attribute = tag.getAttributeEx(inlineAttributeName);
        if (attribute == null) {
            return null;
        }
        if (!(attribute instanceof PageAttribute)) {
            throw new RuntimeException("attribute must be an instance of PageAttribute");
        }
        PageAttribute inlineAttribute = (PageAttribute)attribute;
        CompiledExpression compiledExpression = this.compileExpression((PageAttribute)inlineAttribute, (TagInfo)new TagInfo((Tag)tag)).compiledExpression;
        Object evaluatedInline = compiledExpression.eval(new HashMap());
        if (evaluatedInline != null) {
            TemplateCompiler inlineCompiler = this.inlineCompilers.get(evaluatedInline);
            if (inlineCompiler == null) {
                HTMLTemplatingUtil.throwCompileExceptionForAttribute("No compiler found for inline type: " + evaluatedInline, tag, inlineAttribute, true, this.startPosition);
            }
            return inlineCompiler;
        }
        return null;
    }

    private void throwIfAttributeAlreadyDefined(PageAttribute attribute, CompiledExpressionHolder expression, Tag tag) {
        if (expression != null) {
            HTMLTemplatingUtil.throwCompileExceptionForAttribute("Attribute is defined more than once", tag, attribute, false, this.startPosition);
        }
    }

    public void visitEndTag(Tag tag) {
        String tagName = tag.getTagName();
        ListIterator<VisitorPathElement> iterator = this.visitorPath.listIterator(this.visitorPath.size());
        VisitorPathElement beginTagPathElement = this.findBeginningPathElementForEndTag(tagName, iterator);
        if (this.visitMode == VisitMode.NONE) {
            int depth = this.visitorPath.size();
            if (depth >= this.specialVisitDepth) {
                return;
            }
            this.visitMode = VisitMode.NORMAL;
            if (depth == this.specialVisitDepth - 1) {
                return;
            }
        } else if (this.visitMode == VisitMode.INLINE) {
            int depth = this.visitorPath.size();
            if (depth > this.specialVisitDepth) {
                this.currentSB.append(tag.toHtml(true));
                return;
            }
            TemplateCompiler inlineCompiler = this.inlineContext.templateCompiler;
            ParserConfiguration inlinePC = new ParserConfiguration(this.parserConfiguration.getClassLoader());
            inlinePC.setStartColumn(this.inlineContext.position.column);
            inlinePC.setStartRow(this.inlineContext.position.row);
            CompiledTemplate compiledInline = inlineCompiler.compile(this.currentSB.toString(), inlinePC);
            this.parentNode.getChildren().add(new InlineNode(compiledInline));
            this.currentSB = new StringBuilder();
            this.visitMode = VisitMode.NORMAL;
        }
        if (beginTagPathElement == null || beginTagPathElement.ewtNode == null) {
            this.currentSB.append(tag.toHtml(true));
        } else {
            if (this.currentSB.length() > 0) {
                this.parentNode.getChildren().add(new TextNode(this.currentSB.toString()));
                this.currentSB = new StringBuilder();
            }
            ((TagNode)beginTagPathElement.ewtNode).setEndTag(tag.toHtml(true));
            this.findParentNodeOnIteratorAndSet(iterator);
        }
    }

    public void visitRemarkNode(Remark remark) {
        if (this.visitMode == VisitMode.NONE) {
            return;
        }
        if (this.visitMode == VisitMode.INLINE) {
            this.currentSB.append(remark.toHtml(true));
            return;
        }
        String remarkOpenTag = "<!--";
        int remarkOpenTagLength = remarkOpenTag.length();
        this.currentSB.append(remarkOpenTag);
        String remarkText = remark.getText();
        Lexer lexer = new Lexer(remarkText);
        LinkedList<VisitorPathElement> previousVisitorPath = this.visitorPath;
        ParentNode previousParent = this.parentNode;
        Coordinate previousStartPosition = this.startPosition;
        this.startPosition = HTMLTemplatingUtil.calculateCoordinate(remark.getPage(), remark.getStartPosition() + remarkOpenTagLength, previousStartPosition);
        this.parentNode = new RootNode();
        this.visitorPath = new LinkedList();
        this.visitorPath.add(new VisitorPathElement().withEwtNode(this.parentNode));
        try {
            Node node = lexer.nextNode();
            while (node != null) {
                node.accept((NodeVisitor)this);
                node = lexer.nextNode();
            }
        }
        catch (ParserException e) {
            throw new UncheckedParserException(e);
        }
        this.visitorPath = previousVisitorPath;
        List<HTMLNode> remarkNodes = this.parentNode.getChildren();
        this.parentNode = previousParent;
        this.parentNode.getChildren().addAll(remarkNodes);
        this.startPosition = previousStartPosition;
        this.currentSB.append("-->");
    }

    public void visitStringNode(Text text) {
        if (this.visitMode == VisitMode.NONE) {
            return;
        }
        this.currentSB.append(text.toPlainTextString());
    }

    public void visitTag(Tag tag) {
        if (this.fakeTag(tag)) {
            this.handleFakeTag(tag);
            return;
        }
        if (this.handleTageInNoneAndInlineMode(tag)) {
            return;
        }
        if (this.handleRenderNoneTag(tag)) {
            return;
        }
        Vector attributes = tag.getAttributesEx();
        if (this.isEwtNode(attributes)) {
            this.handleEWTNode(tag, attributes);
        } else {
            this.handleNonEWTNode(tag);
        }
    }

    private static class VisitorPathElement {
        public ParentNode ewtNode;
        public Tag tag;

        private VisitorPathElement() {
        }

        public String toString() {
            if (this.tag == null) {
                return "*root*";
            }
            return this.tag.getTagName();
        }

        public VisitorPathElement withEwtNode(ParentNode ewtNode) {
            this.ewtNode = ewtNode;
            return this;
        }

        public VisitorPathElement withTag(Tag tag) {
            this.tag = tag;
            return this;
        }
    }

    private static enum VisitMode {
        INLINE,
        NONE,
        NORMAL;

    }

    private static class InlineContext {
        public Coordinate position;
        public TemplateCompiler templateCompiler;

        public InlineContext(TemplateCompiler templateCompiler, Coordinate position) {
            this.templateCompiler = templateCompiler;
            this.position = position;
        }
    }
}

