/*
 * Decompiled with CFR 0.152.
 */
package org.everit.templating.html.internal;

import java.util.HashMap;
import java.util.Map;
import org.everit.templating.html.internal.AttributeInfo;
import org.everit.templating.html.internal.ParentNode;
import org.everit.templating.html.internal.TagInfo;
import org.everit.templating.html.internal.TagNode;
import org.everit.templating.html.internal.TemplateContextImpl;
import org.everit.templating.html.internal.util.Coordinate;
import org.everit.templating.html.internal.util.HTMLTemplatingUtil;
import org.everit.templating.util.CompileException;
import org.htmlparser.Tag;
import org.htmlparser.lexer.PageAttribute;

public class RootNode
extends ParentNode {
    private final Map<String, TagNode> fragments = new HashMap<String, TagNode>();

    public void addFragment(String name, TagNode tagNode, PageAttribute attribute, Coordinate templateStartCoordinate, Tag tag) {
        TagNode previous;
        if ("root".equals(name)) {
            HTMLTemplatingUtil.throwCompileExceptionForAttribute("'root' cannot be used as a fragment id as it is reserved for the template itself", tag, attribute, true, templateStartCoordinate);
        }
        if ((previous = this.fragments.get(name)) != null) {
            TagInfo tagInfo = new TagInfo(tag);
            AttributeInfo attributeInfo = new AttributeInfo(attribute, tagInfo, templateStartCoordinate);
            CompileException e = new CompileException("Duplicate fragment: " + name, new TagInfo((Tag)tag).chars, attributeInfo.valueCursorInTag);
            e.setColumn(attributeInfo.valueStartCoordinate.column);
            e.setLineNumber(attributeInfo.valueStartCoordinate.row);
            throw e;
        }
        this.fragments.put(name, tagNode);
    }

    public ParentNode getFragment(String name) {
        if ("root".equals(name)) {
            return this;
        }
        return this.fragments.get(name);
    }

    @Override
    public void render(TemplateContextImpl templateContext) {
        this.renderChildren(templateContext);
    }
}

