/*
 * Decompiled with CFR 0.152.
 */
package org.everit.templating.html.internal.util;

import org.everit.templating.html.internal.util.Coordinate;
import org.everit.templating.util.CompileException;
import org.htmlparser.Tag;
import org.htmlparser.lexer.Page;
import org.htmlparser.lexer.PageAttribute;

public final class HTMLTemplatingUtil {
    private static final String ESCAPED_GT = "&gt;";
    private static final String ESCAPED_LT = "&lt;";
    private static final String ESCAPED_QUOT = "&quot;";
    private static final String ESCAPED_APOS = "&apos;";
    private static final String ESCAPED_AMP = "&amp;";

    public static boolean attributeConstantEquals(String expectedValue, String attributeValue) {
        String normalizedAttributeValue = attributeValue;
        if (normalizedAttributeValue == null) {
            return false;
        }
        if (!((normalizedAttributeValue = normalizedAttributeValue.trim()).startsWith("\"") && normalizedAttributeValue.endsWith("\"") || normalizedAttributeValue.startsWith("'") && normalizedAttributeValue.endsWith("'"))) {
            return false;
        }
        normalizedAttributeValue = normalizedAttributeValue.substring(1, normalizedAttributeValue.length() - 1);
        return normalizedAttributeValue.equalsIgnoreCase(expectedValue);
    }

    public static Coordinate calculateCoordinate(Page page, int cursor, Coordinate coordinateOffset) {
        int row = page.row(cursor);
        int column = page.column(cursor) + (row == 0 ? coordinateOffset.column : 1);
        return new Coordinate(row += coordinateOffset.row, column);
    }

    public static String escape(String textString) {
        StringBuilder sb = new StringBuilder(textString.length());
        int n = textString.length();
        block7: for (int i = 0; i < n; ++i) {
            char charAt = textString.charAt(i);
            switch (charAt) {
                case '&': {
                    sb.append(ESCAPED_AMP);
                    continue block7;
                }
                case '\'': {
                    sb.append(ESCAPED_APOS);
                    continue block7;
                }
                case '\"': {
                    sb.append(ESCAPED_QUOT);
                    continue block7;
                }
                case '<': {
                    sb.append(ESCAPED_LT);
                    continue block7;
                }
                case '>': {
                    sb.append(ESCAPED_GT);
                    continue block7;
                }
                default: {
                    sb.append(charAt);
                }
            }
        }
        return sb.toString();
    }

    public static String repeatChar(char c, int n) {
        char[] chars = new char[n];
        for (int i = 0; i < n; ++i) {
            chars[i] = c;
        }
        return new String(chars);
    }

    public static void throwCompileExceptionForAttribute(String message, Tag tag, PageAttribute attribute, boolean positionOfAttributeValue, Coordinate startPosition) {
        Page page = tag.getPage();
        int tagStartPosition = tag.getStartPosition();
        int tagEndPosition = tag.getEndPosition();
        char[] expr = new char[tagEndPosition - tagStartPosition];
        page.getText(expr, 0, tagStartPosition, tagEndPosition);
        int positionInPage = tagStartPosition + 1;
        int cursor = 1;
        if (attribute != null) {
            positionInPage = positionOfAttributeValue ? attribute.getValueStartPosition() : attribute.getNameStartPosition();
            cursor = positionInPage - tagStartPosition;
        }
        CompileException e = new CompileException(message, expr, cursor);
        Coordinate position = HTMLTemplatingUtil.calculateCoordinate(page, positionInPage, startPosition);
        e.setColumn(position.column);
        e.setLineNumber(position.row);
        throw e;
    }

    public static String unescape(String text) {
        StringBuilder result = new StringBuilder(text.length());
        int i = 0;
        int n = text.length();
        while (i < n) {
            char charAt = text.charAt(i);
            if (charAt != '&') {
                result.append(charAt);
                ++i;
                continue;
            }
            if (text.startsWith(ESCAPED_AMP, i)) {
                result.append('&');
                i += ESCAPED_AMP.length();
                continue;
            }
            if (text.startsWith(ESCAPED_APOS, i)) {
                result.append('\'');
                i += ESCAPED_APOS.length();
                continue;
            }
            if (text.startsWith(ESCAPED_QUOT, i)) {
                result.append('\"');
                i += ESCAPED_QUOT.length();
                continue;
            }
            if (text.startsWith(ESCAPED_LT, i)) {
                result.append('<');
                i += ESCAPED_LT.length();
                continue;
            }
            if (text.startsWith(ESCAPED_GT, i)) {
                result.append('>');
                i += ESCAPED_GT.length();
                continue;
            }
            result.append(charAt);
            ++i;
        }
        return result.toString();
    }

    private HTMLTemplatingUtil() {
    }
}

