/*
 * Decompiled with CFR 0.152.
 */
package org.everit.templating.html.internal;

import java.io.Writer;
import java.util.Map;
import org.everit.templating.CompiledTemplate;
import org.everit.templating.FragmentNotFoundException;
import org.everit.templating.html.internal.ParentNode;
import org.everit.templating.html.internal.RootNode;
import org.everit.templating.html.internal.TemplateContextImpl;
import org.everit.templating.util.InheritantMap;

public class CompiledTemplateImpl
implements CompiledTemplate {
    private final RootNode rootNode;

    public CompiledTemplateImpl(RootNode rootNode) {
        this.rootNode = rootNode;
    }

    public void render(Writer writer, Map<String, Object> vars) {
        this.render(writer, vars, null);
    }

    public void render(Writer writer, Map<String, Object> vars, String fragmentId) {
        ParentNode parentNode;
        String evaluatedBookmark = fragmentId;
        if (fragmentId == null) {
            parentNode = this.rootNode;
            evaluatedBookmark = "root";
        } else {
            parentNode = this.rootNode.getFragment(fragmentId);
            if (parentNode == null) {
                throw new FragmentNotFoundException("Could not find fragment [" + fragmentId + "] in HTML template");
            }
        }
        InheritantMap scopedVars = new InheritantMap(vars, false);
        TemplateContextImpl templateContext = new TemplateContextImpl(this, evaluatedBookmark, (Map<String, Object>)scopedVars, writer);
        scopedVars.putWithoutChecks((Object)"template_ctx", (Object)templateContext);
        parentNode.render(templateContext);
    }
}

