/*
 * Decompiled with CFR 0.152.
 */
package org.everit.templating.text.internal;

import org.everit.expression.CompiledExpression;
import org.everit.expression.ExpressionCompiler;
import org.everit.expression.ParserConfiguration;

public class CompilableNodeHelper {
    private final ExpressionCompiler expressionCompiler;
    private final int line;
    private final int lineStart;
    private final ParserConfiguration originalConfig;

    public CompilableNodeHelper(ParserConfiguration originalConfig, ExpressionCompiler expressionCompiler, int line, int lineStart) {
        this.originalConfig = originalConfig;
        this.expressionCompiler = expressionCompiler;
        this.line = line;
        this.lineStart = lineStart;
    }

    public CompiledExpression compileExpression(char[] template, int start, int length) {
        ParserConfiguration parserConfiguration = new ParserConfiguration(this.originalConfig);
        parserConfiguration.setStartRow(this.line);
        parserConfiguration.setStartColumn(start - this.lineStart + 1);
        String expression = String.valueOf(template, start, length);
        return this.expressionCompiler.compile(expression, parserConfiguration);
    }

    public ExpressionCompiler getExpressionCompiler() {
        return this.expressionCompiler;
    }

    public int getLine() {
        return this.line;
    }

    public int getLineStart() {
        return this.lineStart;
    }

    public ParserConfiguration getOriginalConfig() {
        return this.originalConfig;
    }
}

