/*
 * Decompiled with CFR 0.152.
 */
package org.everit.templating.text.internal;

import org.everit.templating.text.internal.res.ContentRange;
import org.everit.templating.util.CompileException;

public class TextTemplateUtil {
    public static int balancedCapture(char[] chars, int start, char type) {
        return TextTemplateUtil.balancedCapture(chars, start, chars.length, type);
    }

    public static int balancedCapture(char[] chars, int start, int end, char type) {
        int depth = 1;
        char term = type;
        switch (type) {
            case '[': {
                term = ']';
                break;
            }
            case '{': {
                term = '}';
                break;
            }
            case '(': {
                term = ')';
            }
        }
        if (type == term) {
            ++start;
            while (start < end) {
                if (chars[start] == type) {
                    return start;
                }
                ++start;
            }
        } else {
            ++start;
            while (start < end) {
                block32: {
                    if (start < end && chars[start] == '/') {
                        if (start + 1 == end) {
                            return start;
                        }
                        if (chars[start + 1] == '/') {
                            ++start;
                            while (start < end && chars[start] != '\n') {
                                ++start;
                            }
                        } else if (chars[start + 1] == '*') {
                            start += 2;
                            block16: while (start < end) {
                                switch (chars[start]) {
                                    case '*': {
                                        if (start + 1 < end && chars[start + 1] == '/') break block32;
                                    }
                                    default: {
                                        ++start;
                                        continue block16;
                                    }
                                }
                            }
                        }
                    }
                }
                if (start == end) {
                    return start;
                }
                if (chars[start] == '\'' || chars[start] == '\"') {
                    start = TextTemplateUtil.captureStringLiteral(chars[start], chars, start, end);
                } else if (chars[start] == type) {
                    ++depth;
                } else if (chars[start] == term && --depth == 0) {
                    return start;
                }
                ++start;
            }
        }
        switch (type) {
            case '[': {
                throw new CompileException("unbalanced braces [ ... ]", chars, start);
            }
            case '{': {
                throw new CompileException("unbalanced braces { ... }", chars, start);
            }
            case '(': {
                throw new CompileException("unbalanced braces ( ... )", chars, start);
            }
        }
        throw new CompileException("unterminated string literal", chars, start);
    }

    public static int captureStringLiteral(char type, char[] expr, int cursor, int end) {
        while (++cursor < end && expr[cursor] != type) {
            if (expr[cursor] != '\\') continue;
            ++cursor;
        }
        if (cursor >= end || expr[cursor] != type) {
            throw new CompileException("unterminated string literal", expr, cursor);
        }
        return cursor;
    }

    public static ContentRange createStringTrimmed(char[] s, int start, int length) {
        if ((length = start + length) > s.length) {
            return new ContentRange(start, length);
        }
        while (start != length && s[start] < '!') {
            ++start;
        }
        while (length != start && s[length - 1] < '!') {
            --length;
        }
        return new ContentRange(start, length - start);
    }

    public static boolean isWhitespace(char c) {
        return c < '!';
    }

    public static char[] subset(char[] array, int start, int length) {
        char[] newArray = new char[length];
        for (int i = 0; i < newArray.length; ++i) {
            newArray[i] = array[i + start];
        }
        return newArray;
    }
}

