/*
 * Decompiled with CFR 0.152.
 */
package org.everit.templating.text.internal.res;

import java.util.Map;
import org.everit.expression.CompiledExpression;
import org.everit.templating.text.internal.CompilableNodeHelper;
import org.everit.templating.text.internal.TextTemplateUtil;
import org.everit.templating.text.internal.res.ExpressionNode;
import org.everit.templating.text.internal.res.Node;
import org.everit.templating.util.TemplateWriter;

public class IfNode
extends Node {
    private CompiledExpression ce;
    protected Node elseNode;
    protected Node trueNode;

    public IfNode(int begin, String name, char[] template, int start, int end, CompilableNodeHelper helper) {
        super(begin, name, template, start, end);
        while (this.cEnd > this.cStart && TextTemplateUtil.isWhitespace(template[this.cEnd])) {
            --this.cEnd;
        }
        while (this.cEnd > this.cStart && TextTemplateUtil.isWhitespace(template[this.cEnd])) {
            --this.cEnd;
        }
        if (this.cStart != this.cEnd) {
            this.ce = helper.compileExpression(template, this.cStart, this.cEnd - start);
        }
    }

    @Override
    public boolean demarcate(Node terminatingNode, char[] template) {
        this.trueNode = this.next;
        this.next = this.terminus;
        return true;
    }

    @Override
    public Object eval(TemplateWriter appender, Map<String, Object> vars) {
        if (this.evalCE(vars)) {
            return this.trueNode.eval(appender, vars);
        }
        return this.next != null ? this.next.eval(appender, vars) : null;
    }

    private boolean evalCE(Map<String, Object> vars) {
        if (this.ce == null) {
            return true;
        }
        Object result = this.ce.eval(vars);
        if (result == null) {
            return false;
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return Boolean.valueOf(String.valueOf(result));
    }

    public Node getElseNode() {
        return this.elseNode;
    }

    public Node getTrueNode() {
        return this.trueNode;
    }

    public void setElseNode(ExpressionNode elseNode) {
        this.elseNode = elseNode;
    }

    public void setTrueNode(ExpressionNode trueNode) {
        this.trueNode = trueNode;
    }
}

