/*
 * Decompiled with CFR 0.152.
 */
package org.everit.templating.text.internal.res;

import java.util.Map;
import org.everit.templating.text.internal.TextTemplateUtil;
import org.everit.templating.text.internal.res.TerminalNode;
import org.everit.templating.util.TemplateWriter;

public abstract class Node {
    protected int begin;
    protected int cEnd;
    protected char[] contents;
    protected int cStart;
    protected int end;
    protected String name;
    public Node next;
    protected TerminalNode terminus;

    public Node() {
    }

    public Node(int begin, String name, char[] template, int start, int end) {
        this.begin = begin;
        this.cStart = start;
        this.cEnd = end - 1;
        this.end = end;
        this.name = name;
        this.contents = template;
    }

    public Node(int begin, String name, char[] template, int start, int end, Node next) {
        this.name = name;
        this.begin = begin;
        this.cStart = start;
        this.cEnd = end - 1;
        this.end = end;
        this.contents = template;
        this.next = next;
    }

    public void calculateContents(char[] template) {
        this.contents = TextTemplateUtil.subset(template, this.cStart, this.end - this.cStart);
    }

    public abstract boolean demarcate(Node var1, char[] var2);

    public abstract Object eval(TemplateWriter var1, Map<String, Object> var2);

    public int getBegin() {
        return this.begin;
    }

    public int getCEnd() {
        return this.cEnd;
    }

    public char[] getContents() {
        return this.contents;
    }

    public int getCStart() {
        return this.cStart;
    }

    public int getEnd() {
        return this.end;
    }

    public int getLength() {
        return this.end - this.begin;
    }

    public String getName() {
        return this.name;
    }

    public Node getNext() {
        return this.next;
    }

    public TerminalNode getTerminus() {
        return this.terminus;
    }

    public boolean isOpenNode() {
        return false;
    }

    public void setBegin(int begin) {
        this.begin = begin;
    }

    public void setCEnd(int cEnd) {
        this.cEnd = cEnd;
    }

    public void setContents(char[] contents) {
        this.contents = contents;
    }

    public void setCStart(int cStart) {
        this.cStart = cStart;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Node setNext(Node next) {
        this.next = next;
        return this.next;
    }

    public void setTerminus(TerminalNode terminus) {
        this.terminus = terminus;
    }
}

