/*
 * Decompiled with CFR 0.152.
 */
package org.everit.templating.text.internal;

import java.util.HashMap;
import java.util.Map;
import org.everit.expression.ExpressionCompiler;
import org.everit.expression.ParserConfiguration;
import org.everit.templating.text.internal.CompilableNodeHelper;
import org.everit.templating.text.internal.CompiledTemplateImpl;
import org.everit.templating.text.internal.ExecutionStack;
import org.everit.templating.text.internal.ParserContext;
import org.everit.templating.text.internal.TextTemplateUtil;
import org.everit.templating.text.internal.res.CodeNode;
import org.everit.templating.text.internal.res.CommentNode;
import org.everit.templating.text.internal.res.EndNode;
import org.everit.templating.text.internal.res.ExpressionNode;
import org.everit.templating.text.internal.res.ForEachNode;
import org.everit.templating.text.internal.res.FragmentNode;
import org.everit.templating.text.internal.res.IfNode;
import org.everit.templating.text.internal.res.Node;
import org.everit.templating.text.internal.res.TerminalExpressionNode;
import org.everit.templating.text.internal.res.TerminalNode;
import org.everit.templating.text.internal.res.TextNode;
import org.everit.templating.util.CompileException;

public class TextCompiler {
    private static final Map<String, Integer> OPCODES = new HashMap<String, Integer>();
    private int colStart;
    private int cursor;
    private final int end;
    private final ExpressionCompiler expressionCompiler;
    private final Map<String, Node> fragments = new HashMap<String, Node>();
    private int lastTextRangeEnding;
    private int line;
    private final ParserConfiguration parserConfiguration;
    private int start;
    private final char[] template;

    public static boolean isIdentifierPart(int c) {
        return c > 96 && c < 123 || c > 64 && c < 91 || c > 47 && c < 58 || c == 95 || c == 36 || Character.isJavaIdentifierPart(c);
    }

    private static boolean isWhitespace(char c) {
        return c < '!';
    }

    public TextCompiler(char[] document, int templateStart, int templateLength, ExpressionCompiler expressionCompiler, ParserConfiguration parserConfiguration) {
        this.expressionCompiler = expressionCompiler;
        this.parserConfiguration = parserConfiguration;
        this.template = document;
        this.end = templateStart + templateLength;
        this.cursor = templateStart;
    }

    private int balancedCaptureWithLineAccounting(char[] chars, int start, int end, char type, ParserContext pCtx) {
        int st;
        block40: {
            char term;
            int depth;
            block39: {
                depth = 1;
                st = start;
                term = type;
                switch (type) {
                    case '[': {
                        term = ']';
                        break;
                    }
                    case '{': {
                        term = '}';
                        break;
                    }
                    case '(': {
                        term = ')';
                    }
                }
                if (type != term) break block39;
                ++start;
                while (start != end) {
                    if (chars[start] == type) {
                        return start;
                    }
                    ++start;
                }
                break block40;
            }
            int lines = 0;
            ++start;
            while (start < end) {
                block42: {
                    block38: {
                        block41: {
                            if (!TextCompiler.isWhitespace(chars[start])) break block41;
                            switch (chars[start]) {
                                case '\r': {
                                    break block42;
                                }
                                case '\n': {
                                    if (pCtx != null) {
                                        pCtx.setLineOffset((short)start);
                                    }
                                    ++lines;
                                }
                            }
                            break block38;
                        }
                        if (start < end && chars[start] == '/') {
                            if (start + 1 == end) {
                                return start;
                            }
                            if (chars[start + 1] == '/') {
                                ++start;
                                while (start < end && chars[start] != '\n') {
                                    ++start;
                                }
                            } else if (chars[start + 1] == '*') {
                                start += 2;
                                block21: while (start != end) {
                                    switch (chars[start]) {
                                        case '*': {
                                            if (start + 1 < end && chars[start + 1] == '/') break block38;
                                        }
                                        case '\n': 
                                        case '\r': {
                                            if (pCtx != null) {
                                                pCtx.setLineOffset((short)start);
                                            }
                                            ++lines;
                                        }
                                        default: {
                                            ++start;
                                            continue block21;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (start == end) {
                        return start;
                    }
                    if (chars[start] == '\'' || chars[start] == '\"') {
                        start = this.captureStringLiteral(chars[start], chars, start, end);
                    } else if (chars[start] == type) {
                        ++depth;
                    } else if (chars[start] == term && --depth == 0) {
                        if (pCtx != null) {
                            pCtx.incrementLineCount(lines);
                        }
                        return start;
                    }
                }
                ++start;
            }
        }
        switch (type) {
            case '[': {
                throw TextTemplateUtil.createCompileException(this.getTemplateFileName(), "unbalanced braces [ ... ]", chars, st, null);
            }
            case '{': {
                throw TextTemplateUtil.createCompileException(this.getTemplateFileName(), "unbalanced braces { ... }", chars, st, null);
            }
            case '(': {
                throw TextTemplateUtil.createCompileException(this.getTemplateFileName(), "unbalanced braces ( ... )", chars, st, null);
            }
        }
        throw TextTemplateUtil.createCompileException(this.getTemplateFileName(), "unterminated string literal", chars, st, null);
    }

    private char[] capture() {
        char[] newChar = new char[this.cursor - this.start];
        for (int i = 0; i < newChar.length; ++i) {
            newChar[i] = this.template[i + this.start];
        }
        return newChar;
    }

    private int captureOrbInternal() {
        ParserContext pCtx = new ParserContext();
        this.start = this.cursor;
        this.cursor = this.balancedCaptureWithLineAccounting(this.template, this.start, this.end, '{', pCtx);
        this.line += pCtx.getLineCount();
        int ret = this.start + 1;
        this.start = this.cursor + 1;
        return ret;
    }

    private int captureOrbToken() {
        int newStart = ++this.cursor;
        while (this.cursor != this.end && TextCompiler.isIdentifierPart(this.template[this.cursor])) {
            ++this.cursor;
        }
        if (this.cursor != this.end) {
            if (this.template[this.cursor] == '{') {
                return newStart;
            }
            if (this.template[this.cursor] == '\n') {
                ++this.line;
                this.colStart = this.cursor + 1;
            }
        }
        return -1;
    }

    private int captureStringLiteral(char type, char[] expr, int cursor, int end) {
        while (++cursor < end && expr[cursor] != type) {
            if (expr[cursor] != '\\') continue;
            ++cursor;
        }
        if (cursor >= end || expr[cursor] != type) {
            throw TextTemplateUtil.createCompileException(this.getTemplateFileName(), "unterminated string literal", expr, cursor, null);
        }
        return cursor;
    }

    public CompiledTemplateImpl compile() {
        return new CompiledTemplateImpl(this.compileFrom(null, new ExecutionStack()), this.fragments);
    }

    public Node compileFrom(Node root, ExecutionStack stack) {
        this.line = this.parserConfiguration.getStartRow();
        this.colStart = this.cursor - this.parserConfiguration.getStartColumn() + 1;
        Node n = root;
        if (root == null) {
            n = root = new TextNode(this.template, this.cursor, this.cursor);
        }
        block13: while (this.cursor < this.end) {
            block0 : switch (this.template[this.cursor]) {
                case '\n': {
                    ++this.line;
                    this.colStart = this.cursor + 1;
                    break;
                }
                case '$': 
                case '@': {
                    if (this.isNext(this.template[this.cursor])) {
                        this.start = ++this.cursor;
                        n = this.markTextNode(n);
                        n.setEnd(n.getEnd() + 1);
                        this.lastTextRangeEnding = ++this.cursor;
                        this.start = this.cursor;
                        continue block13;
                    }
                    int x = this.captureOrbToken();
                    if (x == -1) break;
                    this.start = x;
                    String name = new String(this.capture());
                    Integer opcode = OPCODES.get(name);
                    switch (opcode == null ? 0 : opcode) {
                        case 1: {
                            n = this.markTextNode((Node)n).next = new IfNode(this.start, name, this.template, this.captureOrbInternal(), this.start, this.createNodeHelper());
                            stack.push(this.markTextNode((Node)n).next);
                            n.setTerminus(new TerminalNode());
                            break block0;
                        }
                        case 2: {
                            if (stack.isEmpty() || !(stack.peek() instanceof IfNode)) break block0;
                            IfNode last = (IfNode)stack.pop();
                            this.markTextNode((Node)n).next = last.getTerminus();
                            last.demarcate(last.getTerminus(), this.template);
                            last.next = n = new IfNode(this.start, name, this.template, this.captureOrbInternal(), this.start, this.createNodeHelper());
                            n.setTerminus(last.getTerminus());
                            stack.push(n);
                            break block0;
                        }
                        case 3: {
                            n = this.markTextNode((Node)n).next = new ForEachNode(this.start, name, this.template, this.captureOrbInternal(), this.start, this.createNodeHelper(), this.getTemplateFileName());
                            stack.push(this.markTextNode((Node)n).next);
                            n.setTerminus(new TerminalNode());
                            break block0;
                        }
                        case 53: {
                            this.start = this.cursor + 1;
                            n = this.markTextNode((Node)n).next = new CodeNode(this.start, name, this.template, this.captureOrbInternal(), this.start, this.createNodeHelper());
                            break block0;
                        }
                        case 52: {
                            this.start = this.cursor + 1;
                            n = this.markTextNode((Node)n).next = new CommentNode(this.start, name, this.template, this.captureOrbInternal(), this.start);
                            break block0;
                        }
                        case 54: {
                            this.start = this.cursor + 1;
                            n = this.markTextNode((Node)n).next = new FragmentNode(this.start, name, this.template, this.captureOrbInternal(), this.start, this.createNodeHelper(), this.fragments, this.getTemplateFileName());
                            stack.push(this.markTextNode((Node)n).next);
                            n.setTerminus(new TerminalNode());
                            break block0;
                        }
                        case 10: {
                            n = this.markTextNode(n);
                            Node end = (Node)stack.pop();
                            TerminalNode terminal = end.getTerminus();
                            terminal.setLine(this.line);
                            int tmpColStart = this.colStart;
                            terminal.setCStart(this.captureOrbInternal());
                            terminal.setColumn(terminal.getCStart() - tmpColStart + 1);
                            this.lastTextRangeEnding = this.start;
                            terminal.setEnd(this.lastTextRangeEnding - 1);
                            terminal.calculateContents(this.template);
                            if (end.demarcate(terminal, this.template)) {
                                n = n.next = terminal;
                                break block0;
                            }
                            n = terminal;
                            break block0;
                        }
                    }
                    if (name.length() == 0) {
                        this.start = this.cursor + 1;
                        n = this.markTextNode((Node)n).next = new ExpressionNode(this.start, name, this.template, this.captureOrbInternal(), this.start, this.createNodeHelper());
                        break;
                    }
                    CompileException e = TextTemplateUtil.createCompileException(this.getTemplateFileName(), "unknown token type: " + name, this.template, this.start, null);
                    e.setLineNumber(this.line);
                    e.setColumn(this.start - this.colStart + 1);
                    throw e;
                }
            }
            ++this.cursor;
        }
        if (!stack.isEmpty()) {
            CompileException ce = TextTemplateUtil.createCompileException(this.getTemplateFileName(), "unclosed @" + ((Node)stack.peek()).getName() + "{} block. expected @end{}", this.template, this.cursor, null);
            ce.setColumn(this.cursor - this.colStart + 1);
            ce.setLineNumber(this.line);
            throw ce;
        }
        if (this.start < this.end) {
            n = n.next = new TextNode(this.template, this.start, this.end);
        }
        n.next = new EndNode();
        n = root;
        while (n.getLength() == 0 && (n = n.getNext()) != null) {
        }
        if (n != null && n.getLength() == this.end - 1) {
            if (n instanceof ExpressionNode) {
                return new TerminalExpressionNode(n, this.createNodeHelper());
            }
            return n;
        }
        return root;
    }

    private CompilableNodeHelper createNodeHelper() {
        return new CompilableNodeHelper(this.parserConfiguration, this.expressionCompiler, this.line, this.colStart);
    }

    private String getTemplateFileName() {
        return "[Name: " + this.parserConfiguration.getName() + "] ";
    }

    private boolean isNext(char c) {
        return this.cursor != this.end && this.template[this.cursor + 1] == c;
    }

    private Node markTextNode(Node n) {
        int s;
        int n2 = s = n.getEnd() > this.lastTextRangeEnding ? n.getEnd() : this.lastTextRangeEnding;
        if (s < this.start) {
            this.lastTextRangeEnding = this.start - 1;
            n.next = new TextNode(this.template, s, this.lastTextRangeEnding);
            return n.next;
        }
        return n;
    }

    static {
        OPCODES.put("if", 1);
        OPCODES.put("else", 2);
        OPCODES.put("elseif", 2);
        OPCODES.put("end", 10);
        OPCODES.put("foreach", 3);
        OPCODES.put("fragment", 54);
        OPCODES.put("comment", 52);
        OPCODES.put("code", 53);
    }
}

