/*
 * Decompiled with CFR 0.152.
 */
package org.everit.templating.text.internal.res;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.everit.expression.CompiledExpression;
import org.everit.templating.text.internal.CompilableNodeHelper;
import org.everit.templating.text.internal.TextTemplateUtil;
import org.everit.templating.text.internal.res.ContentRange;
import org.everit.templating.text.internal.res.Node;
import org.everit.templating.text.internal.res.TerminalNode;
import org.everit.templating.util.InheritantMap;
import org.everit.templating.util.TemplateWriter;
import org.everit.templating.util.UniversalIterable;

public class ForEachNode
extends Node {
    private CompiledExpression[] ce;
    private CompiledExpression cSepExpr;
    private final CompilableNodeHelper helper;
    private ContentRange[] item;
    public Node nestedNode;
    private char[] sepExpr;
    private final String templateFileName;

    public ForEachNode(int begin, String name, char[] template, int start, int end, CompilableNodeHelper helper, String templateFileName) {
        super(begin, name, template, start, end);
        this.helper = helper;
        this.templateFileName = templateFileName;
        this.configure();
    }

    private void configure() {
        int start;
        int i;
        ArrayList<ContentRange> items = new ArrayList<ContentRange>();
        ArrayList<ContentRange> expr = new ArrayList<ContentRange>();
        block5: for (i = start = this.cStart; i < this.cEnd; ++i) {
            switch (this.contents[i]) {
                case '\"': 
                case '\'': 
                case '(': 
                case '[': 
                case '{': {
                    i = TextTemplateUtil.balancedCapture(this.contents, i, this.contents[i], this.templateFileName);
                    continue block5;
                }
                case ':': {
                    items.add(TextTemplateUtil.createStringTrimmed(this.contents, start, i - start));
                    start = i + 1;
                    continue block5;
                }
                case ',': {
                    if (expr.size() != items.size() - 1) {
                        throw TextTemplateUtil.createCompileException(this.templateFileName, "unexpected character ',' in foreach tag", this.contents, this.cStart + i, null);
                    }
                    expr.add(TextTemplateUtil.createStringTrimmed(this.contents, start, i - start));
                    start = i + 1;
                }
            }
        }
        if (start < this.cEnd) {
            if (expr.size() != items.size() - 1) {
                throw TextTemplateUtil.createCompileException(this.templateFileName, "expected character ':' in foreach tag", this.contents, this.cStart, null);
            }
            expr.add(TextTemplateUtil.createStringTrimmed(this.contents, start, this.cEnd - start));
        }
        this.item = new ContentRange[items.size()];
        i = 0;
        for (ContentRange s : items) {
            this.item[i++] = s;
        }
        this.ce = new CompiledExpression[new String[expr.size()].length];
        i = 0;
        for (ContentRange s : expr) {
            this.ce[i++] = this.helper.compileExpression(this.contents, s.cStart, s.length);
        }
    }

    @Override
    public boolean demarcate(Node terminatingnode, char[] template) {
        this.nestedNode = this.next;
        this.next = this.terminus;
        this.sepExpr = terminatingnode.getContents();
        if (this.sepExpr.length == 0) {
            this.sepExpr = null;
        } else {
            TerminalNode terminalNode = (TerminalNode)terminatingnode;
            CompilableNodeHelper sepHelper = new CompilableNodeHelper(this.helper.getOriginalConfig(), this.helper.getExpressionCompiler(), terminalNode.getLine(), terminalNode.cStart - terminalNode.getColumn() + 1);
            this.cSepExpr = sepHelper.compileExpression(this.contents, terminatingnode.cStart, terminatingnode.end - terminatingnode.cStart);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object eval(TemplateWriter appender, Map<String, Object> vars) {
        iters = new Iterator[this.item.length];
        for (i = 0; i < iters.length; ++i) {
            o = this.ce[i].eval(vars);
            iters[i] = new UniversalIterable(o).iterator();
        }
        localVars = new InheritantMap(vars, true);
        iterate = iters.length;
        while (true) lbl-1000:
        // 6 sources

        {
            for (i = 0; i < iters.length; ++i) {
                if (!iters[i].hasNext()) {
                    --iterate;
                    localVars.put(String.valueOf(this.contents, this.item[i].cStart, this.item[i].length), "");
                    continue;
                }
                localVars.put(String.valueOf(this.contents, this.item[i].cStart, this.item[i].length), iters[i].next());
            }
            if (iterate == 0) break;
            this.nestedNode.eval(appender, (Map<String, Object>)localVars);
            if (this.sepExpr == null) ** continue;
            var6_9 = iters;
            var7_10 = var6_9.length;
            var8_11 = 0;
            while (true) {
                if (var8_11 >= var7_10) ** continue;
                it = var6_9[var8_11];
                if (it.hasNext()) {
                    appender.append(String.valueOf(this.cSepExpr.eval(vars)));
                    ** continue;
                }
                ++var8_11;
            }
            break;
        }
        return this.next != null ? this.next.eval(appender, vars) : null;
    }

    public Node getNestedNode() {
        return this.nestedNode;
    }

    public void setNestedNode(Node nestedNode) {
        this.nestedNode = nestedNode;
    }
}

