/*
 * Decompiled with CFR 0.152.
 */
package org.everit.templating.text.internal;

import org.everit.templating.text.internal.StackElement;

public class ExecutionStack {
    private StackElement element;
    private int size = 0;

    public int deepCount() {
        int count = 0;
        if (this.element == null) {
            return 0;
        }
        ++count;
        StackElement element = this.element;
        while ((element = element.next) != null) {
            ++count;
        }
        return count;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Object peek() {
        if (this.size == 0) {
            return null;
        }
        return this.element.value;
    }

    public Object pop() {
        if (this.size == 0) {
            return null;
        }
        try {
            --this.size;
            Object object = this.element.value;
            return object;
        }
        finally {
            this.element = this.element.next;
            assert (this.size == this.deepCount());
        }
    }

    public void push(Object o) {
        ++this.size;
        this.element = new StackElement(this.element, o);
        assert (this.size == this.deepCount());
    }

    public String toString() {
        StackElement el = this.element;
        if (this.element == null) {
            return "<EMPTY>";
        }
        StringBuilder appender = new StringBuilder().append("[");
        do {
            appender.append(String.valueOf(el.value));
            if (el.next == null) continue;
            appender.append(", ");
        } while ((el = el.next) != null);
        appender.append("]");
        return appender.toString();
    }
}

