/*
 * Decompiled with CFR 0.152.
 */
package org.everit.templating.text.internal.res;

import java.util.HashMap;
import java.util.Map;
import org.everit.expression.CompiledExpression;
import org.everit.templating.text.internal.CompilableNodeHelper;
import org.everit.templating.text.internal.TextTemplateUtil;
import org.everit.templating.text.internal.res.EndNode;
import org.everit.templating.text.internal.res.Node;
import org.everit.templating.util.CompileException;
import org.everit.templating.util.InheritantMap;
import org.everit.templating.util.TemplateWriter;

public class FragmentNode
extends Node {
    private final String fragmentName;
    private final Map<String, Node> fragments;
    private Node nestedNode;

    public FragmentNode(int begin, String name, char[] template, int start, int end, CompilableNodeHelper helper, Map<String, Node> fragments, String templateFileName) {
        this.begin = begin;
        this.name = name;
        this.contents = template;
        this.cStart = start;
        this.fragments = fragments;
        this.cEnd = end - 1;
        this.end = end;
        CompiledExpression ce = helper.compileExpression(template, this.cStart, this.cEnd - this.cStart);
        Object fragmentNameObject = ce.eval(new HashMap());
        if (fragmentNameObject == null || !(fragmentNameObject instanceof String)) {
            CompileException e = TextTemplateUtil.createCompileException(templateFileName, "Fragment id must be a constant String: " + fragmentNameObject, template, this.cStart, null);
            e.setColumn(this.cStart - helper.getLineStart() + 1);
            e.setLineNumber(helper.getLine());
            throw e;
        }
        this.fragmentName = (String)fragmentNameObject;
        if (fragments.containsKey(this.fragmentName)) {
            CompileException e = TextTemplateUtil.createCompileException(templateFileName, "Duplicate fragment id: " + this.fragmentName, template, this.cStart, null);
            e.setColumn(this.cStart - helper.getLineStart() + 1);
            e.setLineNumber(helper.getLine());
            throw e;
        }
    }

    @Override
    public boolean demarcate(Node terminatingNode, char[] template) {
        Node n = this.nestedNode = this.next;
        while (n.getNext() != null) {
            n = n.next;
        }
        n.next = new EndNode();
        this.next = this.terminus;
        this.fragments.put(this.fragmentName, this.nestedNode);
        return false;
    }

    @Override
    public Object eval(TemplateWriter appender, Map<String, Object> vars) {
        this.nestedNode.eval(appender, (Map<String, Object>)new InheritantMap(vars, true));
        return this.next != null ? this.next.eval(appender, vars) : null;
    }
}

