/*
 * Decompiled with CFR 0.152.
 */
package org.everit.templating.util;

import java.util.Iterator;

public class UniversalIterable<T>
implements Iterable<T> {
    private final Object collection;
    private final CollectionTypes collectionType;

    public UniversalIterable(Object collection) {
        if (collection == null) {
            throw new NullPointerException("Collection must not be null");
        }
        this.collection = collection;
        if (collection instanceof Iterable) {
            this.collectionType = CollectionTypes.ITERABLE;
        } else if (collection instanceof boolean[]) {
            this.collectionType = CollectionTypes.BOOLEAN_ARRAY;
        } else if (collection instanceof byte[]) {
            this.collectionType = CollectionTypes.BYTE_ARRAY;
        } else if (collection instanceof char[]) {
            this.collectionType = CollectionTypes.CHAR_ARRAY;
        } else if (collection instanceof double[]) {
            this.collectionType = CollectionTypes.DOUBLE_ARRAY;
        } else if (collection instanceof float[]) {
            this.collectionType = CollectionTypes.FLOAT_ARRAY;
        } else if (collection instanceof int[]) {
            this.collectionType = CollectionTypes.INT_ARRAY;
        } else if (collection instanceof long[]) {
            this.collectionType = CollectionTypes.LONG_ARRAY;
        } else if (collection instanceof short[]) {
            this.collectionType = CollectionTypes.SHORT_ARRAY;
        } else if (collection instanceof Object[]) {
            this.collectionType = CollectionTypes.OBJECT_ARRAY;
        } else if (collection instanceof Integer) {
            this.collectionType = CollectionTypes.INTEGER;
        } else {
            throw new IllegalArgumentException("Unrecognized type of collection (Iterable, Array and number are accepted): " + collection.getClass());
        }
    }

    @Override
    public Iterator<T> iterator() {
        AbstractIterator result = null;
        switch (this.collectionType) {
            case BOOLEAN_ARRAY: {
                result = new BooleanArrayIterator((boolean[])this.collection);
                break;
            }
            case BYTE_ARRAY: {
                result = new ByteArrayIterator((byte[])this.collection);
                break;
            }
            case CHAR_ARRAY: {
                result = new CharArrayIterator((char[])this.collection);
                break;
            }
            case DOUBLE_ARRAY: {
                result = new DoubleArrayIterator((double[])this.collection);
                break;
            }
            case FLOAT_ARRAY: {
                result = new FloatArrayIterator((float[])this.collection);
                break;
            }
            case INT_ARRAY: {
                result = new IntArrayIterator((int[])this.collection);
                break;
            }
            case LONG_ARRAY: {
                result = new LongArrayIterator((long[])this.collection);
                break;
            }
            case OBJECT_ARRAY: {
                result = new ObjectArrayIterator((Object[])this.collection);
                break;
            }
            case SHORT_ARRAY: {
                result = new ShortArrayIterator((short[])this.collection);
                break;
            }
            case ITERABLE: {
                Iterable iterable = (Iterable)this.collection;
                result = iterable.iterator();
                break;
            }
            case INTEGER: {
                result = new IntegerIterator((Integer)this.collection);
            }
        }
        Iterator typedResult = result;
        return typedResult;
    }

    private static class ShortArrayIterator
    extends AbstractArrayIterator<Short> {
        private final short[] array;

        public ShortArrayIterator(short[] array) {
            super(array.length);
            this.array = array;
        }

        @Override
        public Short element(int index) {
            return this.array[index];
        }
    }

    private static class ObjectArrayIterator
    extends AbstractArrayIterator<Object> {
        private final Object[] array;

        public ObjectArrayIterator(Object[] array) {
            super(array.length);
            this.array = array;
        }

        @Override
        public Object element(int index) {
            return this.array[index];
        }
    }

    private static class LongArrayIterator
    extends AbstractArrayIterator<Long> {
        private final long[] array;

        public LongArrayIterator(long[] array) {
            super(array.length);
            this.array = array;
        }

        @Override
        public Long element(int index) {
            return this.array[index];
        }
    }

    private static class IntegerIterator
    extends AbstractIterator<Integer> {
        private int cursor = 0;
        private final int n;

        public IntegerIterator(Integer n) {
            this.n = n;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.n;
        }

        @Override
        public Integer next() {
            return this.cursor++;
        }
    }

    private static class IntArrayIterator
    extends AbstractArrayIterator<Integer> {
        private final int[] array;

        public IntArrayIterator(int[] array) {
            super(array.length);
            this.array = array;
        }

        @Override
        public Integer element(int index) {
            return this.array[index];
        }
    }

    private static class FloatArrayIterator
    extends AbstractArrayIterator<Float> {
        private final float[] array;

        public FloatArrayIterator(float[] array) {
            super(array.length);
            this.array = array;
        }

        @Override
        public Float element(int index) {
            return Float.valueOf(this.array[index]);
        }
    }

    private static class DoubleArrayIterator
    extends AbstractArrayIterator<Double> {
        private final double[] array;

        public DoubleArrayIterator(double[] array) {
            super(array.length);
            this.array = array;
        }

        @Override
        public Double element(int index) {
            return this.array[index];
        }
    }

    private static enum CollectionTypes {
        BOOLEAN_ARRAY,
        BYTE_ARRAY,
        CHAR_ARRAY,
        DOUBLE_ARRAY,
        FLOAT_ARRAY,
        INT_ARRAY,
        INTEGER,
        ITERABLE,
        LONG_ARRAY,
        OBJECT_ARRAY,
        SHORT_ARRAY;

    }

    private static class CharArrayIterator
    extends AbstractArrayIterator<Character> {
        private final char[] array;

        public CharArrayIterator(char[] array) {
            super(array.length);
            this.array = array;
        }

        @Override
        public Character element(int index) {
            return Character.valueOf(this.array[index]);
        }
    }

    private static class ByteArrayIterator
    extends AbstractArrayIterator<Byte> {
        private final byte[] array;

        public ByteArrayIterator(byte[] array) {
            super(array.length);
            this.array = array;
        }

        @Override
        public Byte element(int index) {
            return this.array[index];
        }
    }

    private static class BooleanArrayIterator
    extends AbstractArrayIterator<Boolean> {
        private final boolean[] array;

        public BooleanArrayIterator(boolean[] array) {
            super(array.length);
            this.array = array;
        }

        @Override
        public Boolean element(int index) {
            return this.array[index];
        }
    }

    private static abstract class AbstractIterator<T>
    implements Iterator<T> {
        private AbstractIterator() {
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static abstract class AbstractArrayIterator<T>
    extends AbstractIterator<T> {
        private int cursor = 0;
        private final int length;

        public AbstractArrayIterator(int length) {
            this.length = length;
        }

        public abstract T element(int var1);

        @Override
        public boolean hasNext() {
            return this.cursor < this.length;
        }

        @Override
        public T next() {
            return this.element(this.cursor++);
        }
    }
}

