/*
 * Decompiled with CFR 0.152.
 */
package org.everit.templating.util;

public class CompileException
extends RuntimeException {
    private static final long serialVersionUID = 1248035313147803625L;
    private static final int SHOWN_TEXT_AFTER_EXCEPTION_POSITION = 30;
    private static final int SHOWN_TEXT_BEFORE_EXCEPTION_POSITION = 20;
    private int column = 0;
    private int cursor = 0;
    private char[] expr;
    private int lineNumber = 1;
    private int msgOffset = 0;

    private static boolean isWhitespace(char c) {
        return c <= ' ';
    }

    private static String repeatChar(char c, int times) {
        char[] n = new char[times];
        for (int i = 0; i < times; ++i) {
            n[i] = c;
        }
        return new String(n);
    }

    public CompileException(String message, char[] expr, int cursor) {
        super(message);
        this.expr = expr;
        this.cursor = cursor;
    }

    public CompileException(String message, char[] expr, int cursor, Throwable e) {
        super(message, e);
        this.expr = expr;
        this.cursor = cursor;
    }

    private void calcRowAndColumn() {
        if (this.lineNumber > 1 || this.column > 1) {
            return;
        }
        int row = 1;
        int col = 1;
        if (this.lineNumber != 0 && this.column != 0 || this.expr == null || this.expr.length == 0) {
            return;
        }
        block4: for (int i = 0; i < this.cursor && i < this.expr.length; ++i) {
            switch (this.expr[i]) {
                case '\r': {
                    continue block4;
                }
                case '\n': {
                    ++row;
                    col = 1;
                    continue block4;
                }
                default: {
                    ++col;
                }
            }
        }
        this.lineNumber = row;
        this.column = col;
    }

    private String calculateCs(String pCs, String match) {
        String cs = pCs;
        while (true) {
            int matchIndex;
            int firstCr = cs.indexOf(10);
            int lastCr = cs.lastIndexOf(10);
            if (firstCr == -1) break;
            int n = matchIndex = match == null ? 0 : cs.indexOf(match);
            if (firstCr == lastCr) {
                if (firstCr > matchIndex) {
                    cs = cs.substring(0, firstCr);
                    continue;
                }
                if (firstCr >= matchIndex) continue;
                cs = cs.substring(firstCr + 1, cs.length());
                continue;
            }
            if (firstCr < matchIndex) {
                cs = cs.substring(firstCr + 1, lastCr);
                continue;
            }
            cs = cs.substring(0, firstCr);
        }
        return cs;
    }

    private String calculateMatch(char[] expr, int matchStart) {
        String match = new String(expr, matchStart, expr.length - matchStart);
        for (int i = 0; i < match.length(); ++i) {
            char charAt = match.charAt(i);
            if (charAt != '\n' && charAt != ')') continue;
            match = match.substring(0, i);
            break;
        }
        if (match.length() >= 30) {
            match = match.substring(0, 30);
        }
        return match;
    }

    private String generateErrorMessage() {
        StringBuilder appender = new StringBuilder().append("[Error: " + super.getMessage() + "]\n");
        int offset = appender.length();
        appender.append("[Near : {... ");
        offset = appender.length() - offset;
        appender.append(this.showCodeNearError(this.expr, this.cursor)).append(" ....}]\n").append(CompileException.repeatChar(' ', offset));
        if (this.msgOffset < 0) {
            this.msgOffset = 0;
        }
        appender.append(CompileException.repeatChar(' ', this.msgOffset)).append('^');
        this.calcRowAndColumn();
        if (this.lineNumber != -1) {
            appender.append('\n').append("[Line: " + this.lineNumber + ", Column: " + this.column + "]");
        }
        return appender.toString();
    }

    public CharSequence getCodeNearError() {
        return this.showCodeNearError(this.expr, this.cursor);
    }

    public int getColumn() {
        return this.column;
    }

    public int getCursor() {
        return this.cursor;
    }

    public int getCursorOffet() {
        return this.msgOffset;
    }

    public char[] getExpr() {
        return (char[])this.expr.clone();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public String getMessage() {
        return this.generateErrorMessage();
    }

    private void resolveMsgOffset(int cursor, String cs, int matchOffset, String match, String trimmed) {
        this.msgOffset = match != null ? trimmed.indexOf(match) + matchOffset : cs.length() - (cs.length() - trimmed.length());
        if (this.msgOffset == 0 && matchOffset == 0) {
            this.msgOffset = cursor;
        }
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public void setCursor(int cursor) {
        this.cursor = cursor;
    }

    public void setExpr(char[] expr) {
        this.expr = expr;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    private CharSequence showCodeNearError(char[] expr, int cursor) {
        if (expr == null) {
            return "Unknown";
        }
        int start = cursor - 20;
        int end = cursor + 30;
        if (end > expr.length) {
            end = expr.length;
            start -= 30;
        }
        if (start < 0) {
            start = 0;
        }
        String cs = String.copyValueOf(expr, start, end - start);
        int matchStart = -1;
        int matchOffset = 0;
        String match = null;
        if (cursor < end) {
            for (matchStart = cursor; matchStart > 0 && !CompileException.isWhitespace(expr[matchStart - 1]); --matchStart) {
            }
            matchOffset = cursor - matchStart;
            match = this.calculateMatch(expr, matchStart);
        }
        cs = this.calculateCs(cs, match);
        String trimmed = cs.trim();
        this.resolveMsgOffset(cursor, cs, matchOffset, match, trimmed);
        return trimmed;
    }

    @Override
    public String toString() {
        return this.generateErrorMessage();
    }
}

