/*
 * Decompiled with CFR 0.152.
 */
package org.everit.templating.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.everit.templating.util.ReservedWordException;

public class InheritantMap<K, V>
implements Map<K, V> {
    private final Map<K, V> internalMap;
    private final Map<K, V> parentMap;
    private final boolean updateOnParent;

    public InheritantMap(Map<K, V> parentMap, boolean updateOnParent) {
        this(parentMap, new HashMap(), updateOnParent);
    }

    public InheritantMap(Map<K, V> parentMap, Map<K, V> childMap, boolean updateOnParent) {
        this.parentMap = parentMap;
        this.internalMap = childMap;
        this.updateOnParent = updateOnParent;
    }

    @Override
    public void clear() {
        this.internalMap.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        boolean result = this.internalMap.containsKey(key);
        if (!result && this.parentMap != null) {
            return this.parentMap.containsKey(key);
        }
        return result;
    }

    @Override
    public boolean containsValue(Object value) {
        boolean result = this.internalMap.containsValue(value);
        if (!result && this.parentMap != null) {
            return this.parentMap.containsValue(value);
        }
        return result;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InheritantMap other = (InheritantMap)obj;
        if (this.internalMap == null ? other.internalMap != null : !this.internalMap.equals(other.internalMap)) {
            return false;
        }
        return !(this.parentMap == null ? other.parentMap != null : !this.parentMap.equals(other.parentMap));
    }

    @Override
    public V get(Object key) {
        V result = this.internalMap.get(key);
        if (result != null) {
            return result;
        }
        if (!this.internalMap.containsKey(key)) {
            return this.parentMap.get(key);
        }
        return null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.internalMap == null ? 0 : this.internalMap.hashCode());
        result = 31 * result + (this.parentMap == null ? 0 : this.parentMap.hashCode());
        return result;
    }

    @Override
    public boolean isEmpty() {
        boolean result = this.internalMap.isEmpty();
        if (result && this.parentMap != null) {
            return this.parentMap.isEmpty();
        }
        return result;
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public V put(K key, V value) {
        if ("template_ctx".equals(key)) {
            throw new ReservedWordException("'template_ctx' is a reserved word");
        }
        if (this.updateOnParent && this.parentMap != null && this.parentMap.containsKey(key)) {
            return this.parentMap.put(key, value);
        }
        return this.internalMap.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public V putWithoutChecks(K key, V value) {
        return this.internalMap.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.internalMap.remove(key);
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }
}

