/*
 * Decompiled with CFR 0.152.
 */
package org.everit.templating.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class UniversalIterable<T>
implements Iterable<T> {
    private final Object collection;
    private final CollectionTypes collectionType;

    public UniversalIterable(Object collection) {
        if (collection == null) {
            throw new NullPointerException("Collection must not be null");
        }
        CollectionTypes[] collectionTypeArray = CollectionTypes.values();
        CollectionTypes selectedCollectionType = null;
        Class<?> collectionClass = collection.getClass();
        int n = collectionTypeArray.length;
        for (int i = 0; i < n && selectedCollectionType == null; ++i) {
            if (!collectionTypeArray[i].getCollectionType().isAssignableFrom(collectionClass)) continue;
            selectedCollectionType = collectionTypeArray[i];
        }
        if (selectedCollectionType == null) {
            throw new IllegalArgumentException("Unrecognized type of collection (Iterable, Array and number are accepted): " + collectionClass);
        }
        this.collectionType = selectedCollectionType;
        this.collection = collection;
    }

    @Override
    public Iterator<T> iterator() {
        AbstractIterator result = null;
        switch (this.collectionType) {
            case BOOLEAN_ARRAY: {
                result = new BooleanArrayIterator((boolean[])this.collection);
                break;
            }
            case BYTE_ARRAY: {
                result = new ByteArrayIterator((byte[])this.collection);
                break;
            }
            case CHAR_ARRAY: {
                result = new CharArrayIterator((char[])this.collection);
                break;
            }
            case DOUBLE_ARRAY: {
                result = new DoubleArrayIterator((double[])this.collection);
                break;
            }
            case FLOAT_ARRAY: {
                result = new FloatArrayIterator((float[])this.collection);
                break;
            }
            case INT_ARRAY: {
                result = new IntArrayIterator((int[])this.collection);
                break;
            }
            case LONG_ARRAY: {
                result = new LongArrayIterator((long[])this.collection);
                break;
            }
            case OBJECT_ARRAY: {
                result = new ObjectArrayIterator((Object[])this.collection);
                break;
            }
            case SHORT_ARRAY: {
                result = new ShortArrayIterator((short[])this.collection);
                break;
            }
            case ITERABLE: {
                Iterable iterable = (Iterable)this.collection;
                result = iterable.iterator();
                break;
            }
            case INTEGER: {
                result = new IntegerIterator((Integer)this.collection);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        Iterator typedResult = result;
        return typedResult;
    }

    private static class ShortArrayIterator
    extends AbstractArrayIterator<Short> {
        private final short[] array;

        ShortArrayIterator(short[] array) {
            super(array.length);
            this.array = array;
        }

        @Override
        public Short element(int index) {
            return this.array[index];
        }
    }

    private static class ObjectArrayIterator
    extends AbstractArrayIterator<Object> {
        private final Object[] array;

        ObjectArrayIterator(Object[] array) {
            super(array.length);
            this.array = array;
        }

        @Override
        public Object element(int index) {
            return this.array[index];
        }
    }

    private static class LongArrayIterator
    extends AbstractArrayIterator<Long> {
        private final long[] array;

        LongArrayIterator(long[] array) {
            super(array.length);
            this.array = array;
        }

        @Override
        public Long element(int index) {
            return this.array[index];
        }
    }

    private static class IntegerIterator
    extends AbstractIterator<Integer> {
        private int cursor = 0;
        private final int n;

        IntegerIterator(Integer n) {
            this.n = n;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.n;
        }

        @Override
        public Integer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.cursor++;
        }
    }

    private static class IntArrayIterator
    extends AbstractArrayIterator<Integer> {
        private final int[] array;

        IntArrayIterator(int[] array) {
            super(array.length);
            this.array = array;
        }

        @Override
        public Integer element(int index) {
            return this.array[index];
        }
    }

    private static class FloatArrayIterator
    extends AbstractArrayIterator<Float> {
        private final float[] array;

        FloatArrayIterator(float[] array) {
            super(array.length);
            this.array = array;
        }

        @Override
        public Float element(int index) {
            return Float.valueOf(this.array[index]);
        }
    }

    private static class DoubleArrayIterator
    extends AbstractArrayIterator<Double> {
        private final double[] array;

        DoubleArrayIterator(double[] array) {
            super(array.length);
            this.array = array;
        }

        @Override
        public Double element(int index) {
            return this.array[index];
        }
    }

    private static enum CollectionTypes {
        BOOLEAN_ARRAY(boolean[].class),
        BYTE_ARRAY(byte[].class),
        CHAR_ARRAY(char[].class),
        DOUBLE_ARRAY(double[].class),
        FLOAT_ARRAY(float[].class),
        INT_ARRAY(int[].class),
        INTEGER(Integer.class),
        ITERABLE(Iterable.class),
        LONG_ARRAY(long[].class),
        OBJECT_ARRAY(Object[].class),
        SHORT_ARRAY(short[].class);

        private final Class<?> collectionType;

        private CollectionTypes(Class<?> collectionType) {
            this.collectionType = collectionType;
        }

        public Class<?> getCollectionType() {
            return this.collectionType;
        }
    }

    private static class CharArrayIterator
    extends AbstractArrayIterator<Character> {
        private final char[] array;

        CharArrayIterator(char[] array) {
            super(array.length);
            this.array = array;
        }

        @Override
        public Character element(int index) {
            return Character.valueOf(this.array[index]);
        }
    }

    private static class ByteArrayIterator
    extends AbstractArrayIterator<Byte> {
        private final byte[] array;

        ByteArrayIterator(byte[] array) {
            super(array.length);
            this.array = array;
        }

        @Override
        public Byte element(int index) {
            return this.array[index];
        }
    }

    private static class BooleanArrayIterator
    extends AbstractArrayIterator<Boolean> {
        private final boolean[] array;

        BooleanArrayIterator(boolean[] array) {
            super(array.length);
            this.array = array;
        }

        @Override
        public Boolean element(int index) {
            return this.array[index];
        }
    }

    private static abstract class AbstractIterator<T>
    implements Iterator<T> {
        private AbstractIterator() {
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static abstract class AbstractArrayIterator<T>
    extends AbstractIterator<T> {
        private int cursor = 0;
        private final int length;

        AbstractArrayIterator(int length) {
            this.length = length;
        }

        public abstract T element(int var1);

        @Override
        public boolean hasNext() {
            return this.cursor < this.length;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.element(this.cursor++);
        }
    }
}

