/*
 * Decompiled with CFR 0.152.
 */
package org.everit.web.partialresponse;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.Consumer;
import javax.servlet.ServletResponse;
import org.everit.web.partialresponse.internal.HTMLEscapeWriterWrapper;

public class PartialResponseBuilder
implements Closeable {
    private PrintWriter escapedWriter;
    private final PrintWriter writer;

    public PartialResponseBuilder(ServletResponse response) {
        Objects.requireNonNull(response, "Response cannot be null!");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        response.setContentType("text/html");
        try {
            this.writer = response.getWriter();
            this.escapedWriter = new PrintWriter(new HTMLEscapeWriterWrapper(response.getWriter()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.writer.write("<partial-response>");
    }

    public PartialResponseBuilder append(String selector, Consumer<PrintWriter> contentProvider) {
        this.writer.write("<partial-append ");
        this.writer.write("selector='");
        this.escapedWriter.write(selector);
        this.writer.write("'>");
        contentProvider.accept(this.escapedWriter);
        this.writer.write("</partial-append>");
        return this;
    }

    public PartialResponseBuilder append(String selector, String content) {
        this.append(selector, (PrintWriter pwriter) -> pwriter.write(content));
        return this;
    }

    @Override
    public void close() {
        this.writer.write("</partial-response>");
    }

    public PartialResponseBuilder prepend(String selector, Consumer<PrintWriter> contentProvider) {
        this.writer.write("<partial-prepend ");
        this.writer.write("selector='");
        this.escapedWriter.write(selector);
        this.writer.write("'>");
        contentProvider.accept(this.escapedWriter);
        this.writer.write("</partial-prepend>");
        return this;
    }

    public PartialResponseBuilder prepend(String selector, String content) {
        this.prepend(selector, (PrintWriter pwriter) -> pwriter.write(content));
        return this;
    }

    public PartialResponseBuilder replace(String selector, Consumer<PrintWriter> contentProvider) {
        this.writer.write("<partial-replace ");
        this.writer.write("selector='");
        this.escapedWriter.write(selector);
        this.writer.write("'>");
        contentProvider.accept(this.escapedWriter);
        this.writer.write("</partial-replace>");
        return this;
    }

    public PartialResponseBuilder replace(String selector, String newContent) {
        this.replace(selector, (PrintWriter pwriter) -> pwriter.write(newContent));
        return this;
    }

    public PartialResponseBuilder replaceById(Consumer<PrintWriter> contentProvider) {
        this.writer.write("<partial-replace>");
        contentProvider.accept(this.escapedWriter);
        this.writer.write("</partial-replace>");
        return this;
    }

    public PartialResponseBuilder replaceById(String newContent) {
        this.replaceById((PrintWriter pwriter) -> pwriter.write(newContent));
        return this;
    }
}

