/*
 * Decompiled with CFR 0.152.
 */
package org.everit.web.partialresponse.internal;

import java.io.IOException;
import java.io.Writer;

public class HTMLEscapeWriterWrapper
extends Writer {
    private final Writer wrapped;

    public HTMLEscapeWriterWrapper(Writer wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public void close() throws IOException {
        this.wrapped.close();
    }

    @Override
    public void flush() throws IOException {
        this.wrapped.flush();
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        StringBuilder sb = new StringBuilder(len);
        int n = off + len;
        block7: for (int i = off; i < n; ++i) {
            char c = cbuf[i];
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        this.wrapped.write(sb.toString());
    }
}

