/*
 * Copyright (C) 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

if (typeof everit === 'undefined' || everit === null) {
  everit = {};
}

if (typeof everit.partialresponse === 'undefined' || everit.partialresponse === null) {
  everit.partialresponse = {"version" : "1.0.0"};

  everit.partialresponse.process = function(responseContent) {
    var responseObj = $($.parseHTML(responseContent));

    responseObj.children('partial-replace').each(function() {
      var replaceObj = $(this);
      var selector = replaceObj.attr('selector');
      if (typeof selector !== typeof undefined && selector !== false) {
        $(selector).replaceWith($.parseHTML(this.innerText));
      } else {
        $($.parseHTML(this.innerText)).each(function() {
          var newContentObj = $(this);
          var elementId = newContentObj.attr('id');
          var newContentOuterHTML = this.outerHTML;
          $('#' + elementId).replaceWith(newContentOuterHTML);
        });
      }
    });

    responseObj.children('partial-append').each(function() {
      var appendObj = $(this);
      var selector = appendObj.attr('selector');
      $(selector).append($.parseHTML(this.innerText));
    });
  
    responseObj.children('partial-prepend').each(function() {
      var prependObj = $(this);
      var selector = prependObj.attr('selector');
      $(selector).prepend($.parseHTML(this.innerText));
    });
  }
}
