/*
 * Copyright (C) 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.everit.osgi.webresource.internal;

/**
 * Utility functions for internal usage.
 */
public final class WebResourceInternalUtil {

  /**
   * Casting in the way that it is not a problem for findbugs yet it can throw a classcast
   * exception.
   */
  public static <T> T cast(final Object original) {
    @SuppressWarnings("unchecked")
    T result = (T) original;
    return result;
  }

  private WebResourceInternalUtil() {
  }

}
